package meshvizxlm.mesh.data;

import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;
import com.openinventor.meshvizxlm.mesh.data.DataBinding;
import com.openinventor.meshvizxlm.mesh.data.MiScalardSetIjk;

import meshvizxlm.mesh.MbIjkToI;

public class MbScalarSetIjk extends MbDataSet implements MiScalardSetIjk
{
  protected static int s_numInstance = 0;

  private double[] m_scalars;
  private double m_min;
  private double m_max;
  private boolean m_isMinMaxUpToDate;
  protected MbIjkToI m_adaptor;
  protected int m_numI;
  protected int m_numJ;
  protected int m_numK;

  public MbScalarSetIjk(int numI, int numJ, int numK, String name, DataBinding binding)
  {
    super(name, binding);

    s_numInstance++;

    m_adaptor = new MbIjkToI(numI, numJ, numK);
    m_numI = numI;
    m_numJ = numJ;
    m_numK = numK;

    m_scalars = new double[m_numI * m_numJ * m_numK];
    m_isMinMaxUpToDate = false;
  }

  public MbScalarSetIjk(int numI, int numJ, int numK)
  {
    super();

    m_name = "MbScalarSet_#" + s_numInstance;
    s_numInstance++;

    m_adaptor = new MbIjkToI(numI, numJ, numK);
    m_numI = numI;
    m_numJ = numJ;
    m_numK = numK;

    m_scalars = new double[m_numI * m_numJ * m_numK];
    m_isMinMaxUpToDate = false;
  }

  @Override
  public double get(int i, int j, int k)
  {
    return m_scalars[(int) m_adaptor.getI(i, j, k)];
  }

  @Override
  public StorageLayoutIJK getStorageLayout()
  {
    return StorageLayoutIJK.KJI;
  }

  public void set(int i, int j, int k, double data)
  {
    if ( i < m_numI && j < m_numJ && k < m_numK )
    {
      m_scalars[(int) m_adaptor.getI(i, j, k)] = data;
      m_isMinMaxUpToDate = false;
      touch();
    }
  }

  public int[] getSize(int[] size)
  {
    if ( size == null )
      size = new int[3];
    size[0] = m_numI;
    size[1] = m_numJ;
    size[2] = m_numK;

    return size;
  }

  public void setSize(int numI, int numJ, int numK)
  {
    m_adaptor.update(numI, numJ, numK);

    m_numI = numI;
    m_numJ = numJ;
    m_numK = numK;

    m_scalars = new double[m_numI * m_numJ * m_numK];
    m_isMinMaxUpToDate = false;
    touch();
  }

  public double getMin()
  {
    updateMinMax();
    return m_min;
  }

  public double getMax()
  {
    updateMinMax();
    return m_max;
  }

  private void updateMinMax()
  {
    if ( !m_isMinMaxUpToDate )
    {
      m_min = Double.POSITIVE_INFINITY;
      m_max = Double.NEGATIVE_INFINITY;
      for ( double d : m_scalars )
      {
        if ( m_min > d )
          m_min = d;
        if ( m_max < d )
          m_max = d;
      }
      m_isMinMaxUpToDate = true;
    }
  }
}
