package meshvizxlm.mesh.surfaces;

import meshvizxlm.mesh.geometry.MbGeometryIj;
import meshvizxlm.mesh.topology.MbTopologyIj;

import com.openinventor.meshvizxlm.mesh.MiSurfaceMeshCurvilinear;

public class MbSurfaceMeshCurvilinear extends MbMeshIj implements MiSurfaceMeshCurvilinear<MbTopologyIj, MbGeometryIj>
{

  private MbGeometryIj m_geometry;

  public MbSurfaceMeshCurvilinear(int numCellI, int numCellJ)
  {
    super(numCellI, numCellJ);

    m_geometry = new MbGeometryIj(numCellI + 1);
  }

  public void setGeometry(double[] x, double[] y, double[] z)
  {
    m_geometry.assign(x, y, z);
  }

  @Override
  public MbTopologyIj getTopology()
  {
    return m_topology;
  }

  @Override
  public MbGeometryIj getGeometry()
  {
    return m_geometry;
  }
}
