package meshvizxlm.mesh.surfaces;

import meshvizxlm.mesh.MbMesh;
import meshvizxlm.mesh.cell.MbQuadrangleCell;
import meshvizxlm.mesh.geometry.MbMeshGeometry;
import meshvizxlm.mesh.topology.MbQuadrangleCellsSet;

import com.openinventor.meshvizxlm.mesh.MiSurfaceMeshUnstructured;

public class MbSurfaceMeshQuadrangle extends MbMesh implements
    MiSurfaceMeshUnstructured<MbQuadrangleCell, MbQuadrangleCellsSet, MbMeshGeometry>
{
  private MbQuadrangleCellsSet m_topology;

  public MbSurfaceMeshQuadrangle(double[] xArray, double[] yArray, double[] zArray)
  {
    super(xArray, yArray, zArray);

    m_topology = new MbQuadrangleCellsSet();
  }

  @Override
  public MbQuadrangleCellsSet getTopology()
  {
    return m_topology;
  }

  public void setTopology(int... nodeIds)
  {
    m_topology.assign(nodeIds);
  }

  public void setDeadCells(boolean[] flags)
  {
    m_topology.assignDeadFlags(flags);
  }

}
