package meshvizxlm.mesh.topology;

import meshvizxlm.mesh.cell.MbHexahedronCell;

public class MbHexahedronCellsSet extends MbTopologyI<MbHexahedronCell>
{

  protected MbHexahedronCell[] m_cells;
  protected long m_beginNodeId;
  protected long m_endNodeId;

  public MbHexahedronCellsSet()
  {
    this.m_beginNodeId = 0;
    this.m_endNodeId = 0;
    this.m_cells = null;
  }

  @Override
  public MbHexahedronCell getCell(long id)
  {
    return this.m_cells[(int) id];
  }

  @Override
  public long getBeginNodeId()
  {
    return this.m_beginNodeId;
  }

  @Override
  public long getEndNodeId()
  {
    return this.m_endNodeId;
  }

  @Override
  public long getNumCells()
  {
    return this.m_cells.length;
  }

  @Override
  protected void assign(NodeIdProvider provider)
  {
    this.m_beginNodeId = Integer.MAX_VALUE;
    this.m_endNodeId = 0;

    final int numNodes = 8;
    final int numCells = provider.size() / numNodes;
    int[] node = new int[numNodes];
    this.m_cells = new MbHexahedronCell[numCells];

    for ( int iCell = 0, iNode = 0; iCell < numCells; ++iCell )
    {
      for ( int i = 0; i < numNodes; ++i, ++iNode )
      {
        node[i] = provider.get(iNode);

        if ( node[i] + 1 > this.m_endNodeId )
          m_endNodeId = node[i] + 1;
        if ( node[i] < this.m_beginNodeId )
          m_beginNodeId = node[i];
      }

      m_cells[iCell] = new MbHexahedronCell(node[0], node[1], node[2], node[3], node[4], node[5], node[6], node[7]);
    }
    touch();
  }

}
