package meshvizxlm.mesh.topology;

import java.util.ArrayList;
import java.util.List;

import meshvizxlm.mesh.cell.MbPolyhedricCell;

public class MbPolyhedronCellsSet extends MbTopologyI<MbPolyhedricCell>
{

  protected List<MbPolyhedricCell> m_cells;
  protected long m_beginNodeId;
  protected long m_endNodeId;

  public MbPolyhedronCellsSet()
  {
    m_beginNodeId = 0;
    m_endNodeId = 0;
    m_cells = new ArrayList<MbPolyhedricCell>();
  }

  @Override
  public MbPolyhedricCell getCell(long id)
  {
    return m_cells.get((int) id);
  }

  @Override
  public long getBeginNodeId()
  {
    return m_beginNodeId;
  }

  @Override
  public long getEndNodeId()
  {
    return m_endNodeId;
  }

  @Override
  public long getNumCells()
  {
    return this.m_cells.size();
  }

  public void assign(MbPolyhedricCell... cellsToAssign)
  {
    m_cells.clear();
    m_beginNodeId = Integer.MAX_VALUE;
    m_endNodeId = 0;

    for ( MbPolyhedricCell cell : cellsToAssign )
    {
      long cellNodeBeginId = cell.getBeginNodeId();
      long cellNodeEndId = cell.getEndNodeId();

      if ( cellNodeBeginId < m_beginNodeId )
        m_beginNodeId = cellNodeBeginId;

      if ( cellNodeEndId + 1 > m_endNodeId )
        m_endNodeId = cellNodeEndId + 1;

      m_cells.add(cell);
    }

    touch();
  }

  public void assign(int[] faceNodeList, int[] numNodePerFaceList, List<ArrayList<Integer>> cellFacets, int numCells)
  {
    m_cells.clear();
    m_beginNodeId = Integer.MAX_VALUE;
    m_endNodeId = 0;
    MbPolyhedricCell polyCell;

    ArrayList<Long> nodeIdsLst = new ArrayList<Long>();
    long[][] facesList = null;
    int startIndex = 0, lastIndex = 0;
    long nodeId = 0;

    for ( int cell = 0; cell < numCells; cell++ )
    {
      ArrayList<Integer> curCellFacet = cellFacets.get(cell);
      facesList = new long[curCellFacet.size()][];
      nodeIdsLst.clear();

      for ( int i = 0; i < curCellFacet.size(); i++ )
      {
        startIndex = numNodePerFaceList[curCellFacet.get(i)];
        lastIndex = numNodePerFaceList[curCellFacet.get(i) + 1];

        int nbIndex = lastIndex - startIndex;
        facesList[i] = new long[lastIndex - startIndex];

        for ( int j = 0; j < nbIndex; j++ )
        {
          nodeId = (long) faceNodeList[j + startIndex];

          // If node not already added in list, add it
          if ( !nodeIdsLst.contains(nodeId) )
            nodeIdsLst.add((long) faceNodeList[j + startIndex]);

          // In all case, get its index for facet
          facesList[i][j] = nodeIdsLst.indexOf(nodeId);
        }
      }
      // Add new Cell
      polyCell = new MbPolyhedricCell(nodeIdsLst, facesList);

      // Recompute min / max
      if ( polyCell.getBeginNodeId() < m_beginNodeId )
        m_beginNodeId = polyCell.getBeginNodeId();

      if ( polyCell.getEndNodeId() > m_endNodeId )
        m_endNodeId = polyCell.getEndNodeId();

      m_cells.add(polyCell);
    }
  }

  @Override
  protected void assign(NodeIdProvider provider)
  {
    throw new UnsupportedOperationException("Cannot build polyhedric Mesh from list of nodeIds");
  }
}
