package meshvizxlm.mesh.topology;

import java.util.BitSet;

import com.openinventor.meshvizxlm.MxTimeStamp;
import com.openinventor.meshvizxlm.mesh.topology.MiTopologyIj;

import meshvizxlm.mesh.MbIjToI;

/**
 * List of volume cells.
 * <p>
 * An implementation for a IJ implicit mesh topology.
 */
public class MbTopologyIj extends MbTopology implements MiTopologyIj
{

  protected MbIjToI m_adaptor;
  protected int m_numI;
  protected int m_numJ;

  protected boolean m_hasDeadCells;

  public MbTopologyIj(int numCellI, int numCellJ)
  {
    super();

    m_adaptor = new MbIjToI(numCellI);
    m_numI = numCellI;
    m_numJ = numCellJ;

    m_timeStamp = MxTimeStamp.getTimeStamp();
    m_deadCells = new BitSet(m_numI * m_numJ);
    m_hasDeadCells = false;
  }

  @Override
  public long getNumCellsI()
  {
    return m_numI;
  }

  @Override
  public long getNumCellsJ()
  {
    return m_numJ;
  }

  @Override
  public boolean hasDeadCells()
  {
    return m_hasDeadCells;
  }

  @Override
  public boolean isDead(long i, long j)
  {
    return m_deadCells.get((int) m_adaptor.getI(i, j));
  }

  public void setDeadFlag(long i, long j, boolean isDead)
  {
    if ( i < m_numI && j < m_numJ )
    {
      m_deadCells.set((int) m_adaptor.getI(i, j), isDead);
      m_hasDeadCells |= isDead;
      m_timeStamp = MxTimeStamp.getTimeStamp();
    }
  }

}
