package meshvizxlm.mesh.topology;

import java.util.List;

public abstract class NodeIdProvider
{
  public static NodeIdProvider getInstance(List<Integer> nodeIdList)
  {
    return new NodeIdList(nodeIdList);
  }

  public static NodeIdProvider getInstance(int[] nodeIdArray)
  {
    return new NodeIdArray(nodeIdArray);
  }

  public abstract int get(int index);

  public abstract int size();
}

class NodeIdList extends NodeIdProvider
{
  private List<Integer> m_nodeIdList;

  public NodeIdList(List<Integer> nodeIdList)
  {
    m_nodeIdList = nodeIdList;
  }

  @Override
  public int get(int index)
  {
    return m_nodeIdList.get(index);
  }

  @Override
  public int size()
  {
    return m_nodeIdList.size();
  }
}

class NodeIdArray extends NodeIdProvider
{
  private int[] m_nodeIdArray;

  public NodeIdArray(int[] nodeIdArray)
  {
    m_nodeIdArray = nodeIdArray;
  }

  @Override
  public int get(int index)
  {
    return m_nodeIdArray[index];
  }

  @Override
  public int size()
  {
    return m_nodeIdArray.length;
  }
}
