package meshvizxlm.mesh.volumes;

import meshvizxlm.mesh.MbMesh;
import meshvizxlm.mesh.data.MbScalarSetIjk;
import meshvizxlm.mesh.data.MbVec3SetIjk;
import meshvizxlm.mesh.geometry.MbMeshGeometry;
import meshvizxlm.mesh.topology.MbHexahedronTopologyExplicitIjk;

import com.openinventor.meshvizxlm.mesh.MiVolumeMeshHexahedronIjk;
import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;

public class MbHexahedronMeshIjk extends MbMesh
    implements MiVolumeMeshHexahedronIjk<MbHexahedronTopologyExplicitIjk, MbMeshGeometry>
{

  protected MbHexahedronTopologyExplicitIjk m_topology;
  protected MbMeshIjk m_meshIjk;

  public MbHexahedronMeshIjk(int numCellI, int numCellJ, int numCellK, double[] xArray, double[] yArray,
      double[] zArray, StorageLayoutIJK storageLayout)
  {
    super(xArray, yArray, zArray);

    m_meshIjk = new MbMeshIjk();
    m_topology = new MbHexahedronTopologyExplicitIjk(numCellI, numCellJ, numCellK, storageLayout);
  }

  @Override
  public MbHexahedronTopologyExplicitIjk getTopology()
  {
    return m_topology;
  }

  /**
   * Defines hexahedron cell indices
   *
   * @param i
   * @param j
   * @param k
   * @param nodeIds
   */
  public void setCellNodeIndices(int i, int j, int k, int[] nodeIds)
  {
    m_topology.setCellNodeIndices(i, j, k, nodeIds);
  }

  /**
   * Defines dead cells
   *
   * @param i
   * @param j
   * @param k
   * @param isDead
   */
  public void setDeadCells(int i, int j, int k, boolean isDead)
  {
    m_topology.setDeadFlag(i, j, k, isDead);
  }

  public boolean addScalarSetIjk(MbScalarSetIjk scalarSet)
  {
    return m_meshIjk.addScalarSetIjk(scalarSet);
  }

  public boolean addVec3SetIjk(MbVec3SetIjk vectorSet)
  {
    return m_meshIjk.addVec3SetIjk(vectorSet);
  }

  public MbScalarSetIjk getScalarSetIjk(String name)
  {
    return m_meshIjk.getScalarSetIjk(name);
  }

  public MbVec3SetIjk getVec3SetIjk(String name)
  {
    return m_meshIjk.getVec3SetIjk(name);
  }

  public int getNumScalarSetsIjk()
  {
    return m_scalarSets.size();
  }

  public int getNumVec3SetsIjk()
  {
    return m_vec3Sets.size();
  }
}
