package meshvizxlm.mesh.volumes;

import java.util.List;

import meshvizxlm.mesh.cell.MbTetrahedronCell;
import meshvizxlm.mesh.topology.MbTetrahedronCellsSet;

import com.openinventor.meshvizxlm.mesh.topology.MiVolumeTopologyExplicitI;

public class MbVolumeMeshTetrahedron extends MbVolumeMeshUnstructured<MbTetrahedronCell>
{

  protected MbTetrahedronCellsSet m_topology;

  public MbVolumeMeshTetrahedron(double[] xArray, double[] yArray, double[] zArray, List<Integer> nodeIds)
  {
    super(xArray, yArray, zArray);

    this.m_topology = new MbTetrahedronCellsSet();
    setTopology(nodeIds);
  }

  public MbVolumeMeshTetrahedron(double[] xArray, double[] yArray, double[] zArray, int... nodeIds)
  {
    super(xArray, yArray, zArray);

    this.m_topology = new MbTetrahedronCellsSet();
    setTopology(nodeIds);
  }

  @Override
  public MiVolumeTopologyExplicitI<MbTetrahedronCell> getTopology()
  {
    return this.m_topology;
  }

  public void setTopology(List<Integer> nodeIds)
  {
    this.m_topology.assign(nodeIds);
  }

  public void setTopology(int... nodeIds)
  {
    this.m_topology.assign(nodeIds);
  }

  /**
   * Defines dead cells
   */
  public void setDeadCells(boolean[] flags)
  {
    m_topology.assignDeadFlags(flags);
  }

  public int getNumNodes()
  {
    return (int) m_topology.getEndNodeId();
  }

}
