package remoteviz.frontbacksync.frontbacksyncrenderingservice;

import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoGetBoundingBoxAction;
import com.openinventor.remoteviz.rendering.Connection;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaListener;

public class FrontBackSyncRenderArea extends RenderAreaListener
{
  private SbMatrix m_mvp;

  public void setM_mvp(SbMatrix m)
  {
    m_mvp = m;
  }

  @Override
  public boolean[] onPreRender(RenderArea renderArea, boolean clearWindow, boolean clearZbuffer)
  {
    SoGetBoundingBoxAction cba = new SoGetBoundingBoxAction(renderArea.getSceneManager().getViewportRegion());
    cba.apply(renderArea.getSceneManager().getSceneGraph());

    if(m_mvp != null)
    {

      SbViewportRegion vp = renderArea.getSceneManager().getViewportRegion();
      SbVec2s ws = vp.getWindowSize();
      String message = "mat " + m_mvp.getElement(0, 0) + " "
                              + m_mvp.getElement(1, 0) + " "
                              + m_mvp.getElement(2, 0) + " "
                              + m_mvp.getElement(3, 0) + " "

                              + m_mvp.getElement(0, 1) + " "
                              + m_mvp.getElement(1, 1) + " "
                              + m_mvp.getElement(2, 1) + " "
                              + m_mvp.getElement(3, 1) + " "

                              + m_mvp.getElement(0, 2) + " "
                              + m_mvp.getElement(1, 2) + " "
                              + m_mvp.getElement(2, 2) + " "
                              + m_mvp.getElement(3, 2) + " "

                              + m_mvp.getElement(0, 3) + " "
                              + m_mvp.getElement(1, 3) + " "
                              + m_mvp.getElement(2, 3) + " "
                              + m_mvp.getElement(3, 3) + " "

                              + ws.getValueAt(0) + " "
                              + ws.getValueAt(1);
      renderArea.setFrameMessage(message);

    }
    boolean[] array = {true, clearWindow, clearZbuffer};
    return array;
  }

  @Override
  public String onSendingFrame(RenderArea renderArea, Connection sender)
  {
    return sender.getLastEncodedFrame().getMessage();
  }
}
