package remoteviz.helloconeH264.helloconeh264renderingservice;

import com.openinventor.remoteviz.rendering.Connection;
import com.openinventor.remoteviz.rendering.FrameEncoders;
import com.openinventor.remoteviz.rendering.FrameEncoders.Encoders;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaListener;

public class HelloConeH264RenderAreaListener extends RenderAreaListener
{

  @Override
  public void onOpenedConnection(RenderArea renderArea, Connection connection, FrameEncoders frameEncoders)
  {
    frameEncoders.setInteractiveEncoder(Encoders.H264_NVENC);
    frameEncoders.setStillEncoder(Encoders.H264_NVENC);
  }

  @Override
  public void onInitializedConnection(RenderArea renderArea, Connection sender, FrameEncoders frameEncoders)
  {
    if ( frameEncoders.getInteractiveEncoder() == Encoders.JPEG && frameEncoders.getStillEncoder() == Encoders.JPEG )
    {
      System.out.println("New connection using JPEG encoder for interactive and still frames.");
    }
    else if ( frameEncoders.getInteractiveEncoder() == Encoders.JPEG && frameEncoders.getStillEncoder() == Encoders.PNG )
    {
      System.out.println("New connection using JPEG encoder for interactive frames and PNG encoder for still frames.");
    }
    else if ( frameEncoders.getInteractiveEncoder() == Encoders.H264_NVENC && frameEncoders.getStillEncoder() == Encoders.H264_NVENC )
    {
      System.out.println("New connection using NVENC H264 encoder (GPU encoding) for interactive and still frames.");
    }
    else if ( frameEncoders.getInteractiveEncoder() == Encoders.H264_OPENH264 && frameEncoders.getStillEncoder() == Encoders.H264_OPENH264 )
    {
      System.out.println("New connection using OpenH264 encoder (CPU encoding) for interactive and still frames.");
    }
    else
    {
      System.out.println("New connection.");
    }
  }

  @Override
  public void onRefusedEncoder(RenderArea renderArea, Connection sender, FrameEncoders frameEncoders)
  {
    if( frameEncoders.getInteractiveEncoder() == Encoders.H264_NVENC && frameEncoders.getStillEncoder() == Encoders.H264_NVENC )
    {
      frameEncoders.setInteractiveEncoder(Encoders.H264_OPENH264);
      frameEncoders.setStillEncoder(Encoders.H264_OPENH264);
    }
    else if( frameEncoders.getInteractiveEncoder() == Encoders.H264_OPENH264 && frameEncoders.getStillEncoder() == Encoders.H264_OPENH264 )
    {
      frameEncoders.setInteractiveEncoder(Encoders.JPEG);
      frameEncoders.setStillEncoder(Encoders.PNG);
    }
    else if( frameEncoders.getInteractiveEncoder() == Encoders.JPEG && frameEncoders.getStillEncoder() == Encoders.PNG )
    {
      frameEncoders.setInteractiveEncoder(Encoders.JPEG);
      frameEncoders.setStillEncoder(Encoders.JPEG);
    }
    else if( frameEncoders.getInteractiveEncoder() == Encoders.JPEG && frameEncoders.getStillEncoder() == Encoders.JPEG )
    {
      System.out.println("Error: RemoteViz codec libraries are missing.");
      sender.close();
    }
    else
    {
      frameEncoders.setInteractiveEncoder(Encoders.JPEG);
      frameEncoders.setStillEncoder(Encoders.JPEG);
    }
  }
}
