package remoteviz.sharedviewer.sharedviewerrenderingservice;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoSelection;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.remoteviz.rendering.Connection;
import com.openinventor.remoteviz.rendering.FrameEncoders;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaListener;

import java.util.Arrays;
import java.util.List;

public class SharedViewerRenderArea extends RenderAreaListener
{

  private boolean picking = false;
  private String model = null;

  @Override
  public void onOpenedConnection(RenderArea renderArea, Connection connection, FrameEncoders frameEncoders)
  {
    /*
     * Send a message to all the clients of the same renderArea to synchonize
     * the UI
     */

    if ( picking )
    {
      connection.sendMessage("pick on");
    }
    else
    {
      connection.sendMessage("pick off");
    }

    if ( model != null )
      connection.sendMessage(model);

    // Notify the number of connected clients
    renderArea.sendMessage("clients " + renderArea.getNumConnections());

  }

  @Override
  public void onClosedConnection(RenderArea renderArea, String connectionId, boolean aborted)
  {
    // Notify the number of connected clients
    renderArea.sendMessage("clients " + renderArea.getNumConnections());
  }

  @Override
  public void onReceivedMessage(RenderArea renderArea, Connection sender, String message)
  {
    String[] elems = message.split(" "); // split the received message, pattern
                                         // : "COMMAND ARGUMENT"
    if ( elems.length == 2 )
    {
      String command = elems[0];
      String argument = elems[1];

      SoSelection sel = (SoSelection) renderArea.getSceneManager().getSceneGraph();
      SceneExaminer sceneExaminer = (SceneExaminer) sel.getChild(0);

      // parse the commands
      if ( command.equals("open") )
      {
        // Load the new iv file
        SoInput i = new SoInput();
        i.openFile("$OIVJHOME/data/" + argument);
        sceneExaminer.removeChild(sceneExaminer.getNumChildren() - 1);
        sceneExaminer.addChild(SoDB.readAll(i));
        sceneExaminer.viewAll(renderArea.getSceneManager().getViewportRegion());
        model = message;
      }
      else if ( command.equals("pick") )
      {
        // picking mode switch
        if ( argument.equals("on") )
        {
          sceneExaminer.setInteractionMode(SceneExaminer.InteractionMode.SELECTION);
          picking = true;
        }
        else
        {
          sceneExaminer.setInteractionMode(SceneExaminer.InteractionMode.NAVIGATION);
          picking = false;
        }
      }

      /*
       * Send a message to all the clients of the same renderArea to synchonize
       * the UI
       */
      List<Connection> excludedConnections = Arrays.asList( sender );
      renderArea.sendMessage(message, excludedConnections);
    }
    else
    {
      System.out.println("Error in received command (unrecognized message: " + message + ")");
    }
  }

}
