package remoteviz.sharedviewer.sharedviewerrenderingservice;

import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.manips.SoHandleBoxManip;
import com.openinventor.inventor.manips.SoTransformManip;
import com.openinventor.inventor.misc.callbacks.SoSelectionPathCB;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSelection;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.Service;
import com.openinventor.remoteviz.rendering.ServiceListener;
import com.openinventor.remoteviz.rendering.ServiceSettings;

public class SharedViewerService extends ServiceListener
{

  private static boolean running = true;
  private static final Thread mainThread = Thread.currentThread();

  /**
   * @param args
   * @throws InterruptedException
   */
  public static void main(String[] args)
  {
    // Default value for service IP address
    String serviceIPaddress = "127.0.0.1";
    // Default value for service port
    int servicePort = 8080;

    // Use passed values for the service IP address and port
    if ( args.length == 2 )
    {
      serviceIPaddress = args[0];
      servicePort = Integer.parseInt(args[1]);
    }

    // Instantiate a service settings class
    ServiceSettings settings = new ServiceSettings();
    // set the IP address used by the service
    settings.setIP(serviceIPaddress);
    // set the port used by the service
    settings.setPort(servicePort);

    // Add a SharedViewerService class as listener
    Service.instance().addListener(new SharedViewerService());

    // To use an Open Inventor extension with RemoteViz, uncomment the following
    // line and set the extension name.
    // settings.setUsedExtensions(ServiceSettings.Extensions.VOLUMEVIZLDM);

    // Open the service by using the settings
    if ( Service.instance().open(settings) )
    {
      Runtime.getRuntime().addShutdownHook(new Thread()
      {
        @Override
        public void run()
        {
          try
          {
            running = false;
            mainThread.join();
          }
          catch (InterruptedException e)
          {}
        }
      });

      System.out.println("The SharedViewer Rendering Service is running. Press Ctrl + C to stop.");
      try
      {
        // Main loop
        while ( running )
        {
          Service.instance().dispatch();
          Thread.sleep(1);
        }
      }
      catch (InterruptedException ex)
      {}
      finally
      {
        // Close the service
        Service.instance().close();
      }
    }

  }

  class SelectionCB extends SoSelectionPathCB
  {
    @Override
    public void invoke(SoPath path)
    {
      if ( path.regular.getLength() < 2 )
        return;

      // Find the transform affecting this object
      SoPath xfPath = findXform(path);

      // Replace the transform with a manipulator
      SoHandleBoxManip manip = new SoHandleBoxManip();
      manip.replaceNode(xfPath);
    }

    // Returns path to xform left of the input path tail.
    // Inserts the xform if none found. In this example,
    // assume that the xform is always the node preceeding
    // the selected shape.
    SoPath findXform(SoPath p)
    {
      SoPath returnPath;

      // Copy the input path up to tail's parent.
      returnPath = p.regular.copy(0, p.regular.getLength() - 1);

      // Get the parent of the selected shape
      SoGroup g = (SoGroup) p.regular.getNodeFromTail(1);
      int tailNodeIndex = p.regular.getIndexFromTail(0);

      // Check if there is already a transform node
      if ( tailNodeIndex > 0 )
      {
        SoNode n = g.getChild(tailNodeIndex - 1);
        if ( n instanceof SoTransform )
        {
          // Append to returnPath and return it.
          returnPath.regular.append(n);
          return returnPath;
        }
      }

      // Otherwise, add a transform node.
      SoTransform xf = new SoTransform();
      g.insertChild(xf, tailNodeIndex); // right before the tail
      // Append to returnPath and return it.
      returnPath.regular.append(xf);
      return returnPath;
    }
  }

  class DeselectionCB extends SoSelectionPathCB
  {
    @Override
    public void invoke(SoPath path)
    {
      if ( path.regular.getLength() < 2 )
        return;

      // Find the manipulator affecting this object
      SoPath manipPath = findManip(path);

      // Replace the manipulator with a transform
      SoTransformManip manip = (SoTransformManip) manipPath.regular.getTail();
      manip.replaceManip(manipPath, new SoTransform());
    }

    // Returns the manip affecting this path. In this example,
    // the manip is always preceeding the selected shape.
    SoPath findManip(SoPath p)
    {
      SoPath returnPath;

      // Copy the input path up to tail's parent.
      returnPath = p.regular.copy(0, p.regular.getLength() - 1);

      // Get the index of the last node in the path.
      int tailNodeIndex = p.regular.getIndexFromTail(0);

      // Append the left sibling of the tail to the returnPath
      returnPath.regular.append(tailNodeIndex - 1);
      return returnPath;
    }
  }

  @Override
  public void onInstantiatedRenderArea(RenderArea renderArea)
  {
    // Add the renderAreaListener instance as renderArea listener. Each session
    // has its own renderAreaListener.
    if ( renderArea.getId().equals("session1") )
    {
      renderArea.addListener(new SharedViewerRenderArea());
    }
    else if ( renderArea.getId().equals("session2") )
    {
      renderArea.addListener(new SharedViewerRenderArea());
    }
    else if ( renderArea.getId().equals("session3") )
    {
      renderArea.addListener(new SharedViewerRenderArea());
    }

    renderArea.getTouchManager().addDefaultRecognizers();

    SceneExaminer sceneExaminer = new SceneExaminer();

    // Create and set up the selection node
    SoSelection sel = new SoSelection();
    sel.policy.setValue(SoSelection.Policies.SINGLE);
    sel.addSelectionCallback(new SelectionCB());
    sel.addDeselectionCallback(new DeselectionCB());
    sel.addChild(sceneExaminer);

    // Add the color switch
    SoSwitch colorswitch = new SoSwitch();
    SoMaterial material = new SoMaterial();
    material.diffuseColor.setValue(1.0f, 0, 0);
    colorswitch.addChild(material);
    sceneExaminer.addChild(colorswitch);

    sceneExaminer.addChild(new SoGradientBackground());

    renderArea.getSceneManager().setSceneGraph(sel);
    sceneExaminer.viewAll(renderArea.getSceneManager().getViewportRegion());
  }
}
