package volumeviz.advanced.volRend;

import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.*;

public class BBoxSeparator extends SoSeparator {

  private SoTransform m_transform;
  private SbColor m_color;
  private SoIndexedLineSet m_line;

  private float[] m_bboxBounds;

  public BBoxSeparator(SbColor color) {
    super();

    m_color = color;
    m_bboxBounds = new float[6];

    SoDrawStyle pStyle = new SoDrawStyle();
    pStyle.lineWidth.setValue(2);

    SoLightModel pLMod = new SoLightModel();
    pLMod.model.setValue(SoLightModel.Models.BASE_COLOR);

    m_transform = new SoTransform();

    m_line = new SoIndexedLineSet();

    addChild(pStyle);
    addChild(pLMod);
    addChild(m_transform);
    addChild(m_line);
  }

  public void update(SbVec3i32[] bounds) {
  	SbVec3f min = new SbVec3f(bounds[0].getX(), bounds[0].getY(), bounds[0].getZ());
  	SbVec3f max = new SbVec3f(bounds[1].getX(), bounds[1].getY(), bounds[1].getZ());
    SbVec3f[] float_bounds = new SbVec3f[] { min, max};
    update(float_bounds);
  }

  public void update(SbVec3f[] minMax) {
    SoVertexProperty pProp = new SoVertexProperty();

    float[] min = minMax[0].getValue();
    float[] max = minMax[1].getValue();
    float[] bounds = new float[6];
    bounds[0] = min[0]; bounds[1] = min[1]; bounds[2] = min[2];
    bounds[3] = max[0]; bounds[4] = max[1]; bounds[5] = max[2];
    
    pProp.vertex.setNum(8);
    pProp.vertex.set1Value(0, bounds[0], bounds[1], bounds[2]);
    pProp.vertex.set1Value(1, bounds[3], bounds[1], bounds[2]);
    pProp.vertex.set1Value(2, bounds[3], bounds[4], bounds[2]);
    pProp.vertex.set1Value(3, bounds[0], bounds[4], bounds[2]);
    pProp.vertex.set1Value(4, bounds[0], bounds[1], bounds[5]);
    pProp.vertex.set1Value(5, bounds[3], bounds[1], bounds[5]);
    pProp.vertex.set1Value(6, bounds[3], bounds[4], bounds[5]);
    pProp.vertex.set1Value(7, bounds[0], bounds[4], bounds[5]);
    pProp.orderedRGBA.set1Value(0, m_color.getPackedValue());

    int[] indices = {
        0, 1, 2, 3, 0, -1,
        4, 5, 6, 7, 4, -1,
        0, 4, -1,
        1, 5, -1,
        2, 6, -1,
        3, 7, -1
    };

    m_line.vertexProperty.setValue(pProp);
    m_line.coordIndex.setValues(0, indices);

    m_bboxBounds[0] = bounds[0]*m_transform.scaleFactor.getValue().getX() +
        m_transform.translation.getValue().getX();
    m_bboxBounds[1] = bounds[1]*m_transform.scaleFactor.getValue().getY() +
        m_transform.translation.getValue().getY();
    m_bboxBounds[2] = bounds[2]*m_transform.scaleFactor.getValue().getZ() +
        m_transform.translation.getValue().getZ();
    m_bboxBounds[3] = bounds[3]*m_transform.scaleFactor.getValue().getX() +
        m_transform.translation.getValue().getX();
    m_bboxBounds[4] = bounds[4]*m_transform.scaleFactor.getValue().getY() +
        m_transform.translation.getValue().getY();;
    m_bboxBounds[5] = bounds[5]*m_transform.scaleFactor.getValue().getZ() +
        m_transform.translation.getValue().getZ();
  }

  public void setTranslation(SbVec3f trans) {
    m_transform.translation.setValue(trans);
  }

  public void setScaleFactor(float xFactor, float yFactor, float zFactor) {
    m_transform.scaleFactor.setValue(xFactor, yFactor, zFactor);
  }

  public float[] getBBoxBounds() {
    return m_bboxBounds;
  }
}

