package volumeviz.advanced.volRend;

import javax.swing.*;

import java.awt.event.*;
import java.io.*;
import java.awt.*;

import javax.swing.border.*;

public class ChooserPanel extends JPanel {

  private File m_userFile;
  private String[] m_items;

  public JTextField m_filenameField;
  private JComboBox<String> m_filesComboBox;

  public ChooserPanel(String[] comboBox_items, File defaultFile) {
    super();

    m_userFile = defaultFile;
    m_items = comboBox_items;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_filenameField = new JTextField(m_userFile.getName());
    m_filenameField.setPreferredSize(new Dimension(175, 20));
    m_filenameField.setEditable(false);

    JButton browse_button = new JButton("Browse");
    Border button_border =
        BorderFactory.createBevelBorder(BevelBorder.RAISED,
                                        Color.white,Color.white,
                                        new Color(103, 101, 98),
                                        new Color(148, 145, 140));
    browse_button.setBorder(button_border);
    browse_button.setPreferredSize(new Dimension(90, 18));
    browse_button.addMouseListener(new BrowseMouseAdapter());

    JLabel jl1 = new JLabel("User Filename");
    jl1.setPreferredSize(new Dimension(110, 20));

    JPanel panel1 = new JPanel(new BorderLayout());
    panel1.add(jl1, BorderLayout.WEST);
    panel1.add(m_filenameField, BorderLayout.CENTER);
    panel1.add(browse_button, BorderLayout.EAST);

    m_filesComboBox = new JComboBox<>(m_items);

    JLabel jl2 = new JLabel("Predefined Data");
    jl2.setPreferredSize(new Dimension(110, 20));

    JPanel panel2 = new JPanel(new BorderLayout());
    panel2.add(jl2, BorderLayout.WEST);
    panel2.add(m_filesComboBox, BorderLayout.CENTER);

    GridLayout gl = new GridLayout(2, 1);
    gl.setVgap(25);
    setLayout(gl);
    add(panel1);
    add(panel2);
  }

  public File getUserFile()
  {
    return m_userFile;
  }

  public void setSelectedItem(int i) {
    if (i < m_items.length && i >= 0)
      m_filesComboBox.setSelectedIndex(i);
  }

  public void addComboBoxListener(final ChooserComboBoxListener ccbl) {
    m_filesComboBox.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int selected_index = m_filesComboBox.getSelectedIndex();
        ccbl.itemSelectedChanged(selected_index);
      }
    });
  }

  class BrowseMouseAdapter extends MouseAdapter {
    public void mousePressed(MouseEvent e) {
      try {
        String dir = new File(VolRend.m_filePrefix).getCanonicalPath();
        JFileChooser jfc = new JFileChooser(dir);
        if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
          m_userFile = jfc.getSelectedFile();
          m_filenameField.setText(m_userFile.getName());
          m_filesComboBox.setSelectedIndex(m_filesComboBox.getItemCount() - 1);
        }
      }
      catch(Exception exc) {
        exc.printStackTrace();
      }
    }
  }
}
