package volumeviz.advanced.volRend;

import com.openinventor.inventor.nodes.*;
import com.openinventor.ldm.nodes.*;
import com.openinventor.inventor.*;
import com.openinventor.inventor.sensors.*;
import java.nio.*;

public class ColorMapLegend extends SoSeparator {

  private SoTransferFunction m_XferNode;
  private SoTransferFunction m_sliceTransferFunction;
  private SoTexture2 m_legTex2;
  private SoNodeSensor m_sliceXferSensor;
  private SoNodeSensor m_XferSensor;

  public ColorMapLegend(SoTransferFunction Xfer_node, SoTransferFunction slice_transfer) {
    super();
    m_XferNode = Xfer_node;
    m_sliceTransferFunction = slice_transfer;
    create();
  }

  private void create() {
    float legXmin = -.99f;
    float legXmax = -.89f;
    float legYmin = -.8f;
    float legYmax = .8f;
    float[][] legFaceVerts1 = {
        {legXmin, legYmin, 0},
        {legXmax, legYmin, 0},
        {legXmax, legYmax, 0},
        {legXmin, legYmax, 0}
    };
    float[][] legFaceVerts2 = {
        {legXmin, legYmin, 0.0002f},
        {legXmax, legYmin, 0.0002f},
        {legXmax, legYmax, 0.0002f},
        {legXmin, legYmax, 0.0002f}
    };
    float[][] legLineVerts = {
        {legXmin, legYmin, 0.0004f},
        {legXmax, legYmin, 0.0004f},
        {legXmax, legYmax, 0.0004f},
        {legXmin, legYmax, 0.0004f}
    };
    int[] legLineIndex = {0, 1, 2, 3, 0};

    byte[] pChecksImage = {0x00, (byte)0xff, (byte)0xff, 0x00};
    int texIndex[] = {0, 1, 2, 3, 0};
    float[] texCoord1 = {
        0, 1.5f,
        0, 0,
        10, 0,
        10, 1.5f
    };
    float[] texCoord2 = {
        0, 1,
        0, 0,
        1, 0,
        1, 1
    };

    // LineSet to outline colormap
    SoVertexProperty pLegProp = new SoVertexProperty();
    pLegProp.vertex.setValues(0, legLineVerts);
    pLegProp.orderedRGBA.set1Value(0, 0xFFFFFFFF);
    SoIndexedLineSet pLegLine = new SoIndexedLineSet();
    pLegLine.vertexProperty.setValue(pLegProp);
    pLegLine.coordIndex.setValues(0, legLineIndex);

    // First FaceSet = checkerboard
    SoTexture2 pLegTex1 = new SoTexture2();
    SoVertexProperty pLegProp1 = new SoVertexProperty();
    SoIndexedFaceSet pLegFace1 = new SoIndexedFaceSet();

    float legLength = legYmax - legYmin;
    float legHeight = legXmax - legXmin;
    float legAspect = 1.5f * legLength / legHeight;
    texCoord1[4] = legAspect;
    texCoord1[6] = legAspect;
    pLegTex1.image.setValue(new SbVec2s( (short) 2, (short) 2), 1, pChecksImage);
    pLegProp1.vertex.setValues(0, legFaceVerts1);
    pLegProp1.orderedRGBA.set1Value(0, 0xFFFFFFFF);
    pLegProp1.texCoord.setValues(0, texCoord1);
    pLegFace1.vertexProperty.setValue(pLegProp1);
    pLegFace1.coordIndex.setValues(0, legLineIndex);
    pLegFace1.textureCoordIndex.setValues(0, texIndex);

    // Second FaceSet = colormap
    m_legTex2 = new SoTexture2();
    SoVertexProperty pLegProp2 = new SoVertexProperty();
    SoIndexedFaceSet pLegFace2 = new SoIndexedFaceSet();

    updateColorMapLegend(m_XferNode);

    pLegProp2.vertex.setValues(0, legFaceVerts2);
    pLegProp2.orderedRGBA.set1Value(0, 0xFFFFFFFF);
    pLegProp2.texCoord.setValues(0, texCoord2);
    pLegFace2.vertexProperty.setValue(pLegProp2);
    pLegFace2.coordIndex.setValues(0, legLineIndex);
    pLegFace2.textureCoordIndex.setValues(0, texIndex);

    // Pull the legend out close to the near clip plane
    // (Note this depends on how the app setup the camera...)
    SoTranslation pTrans = new SoTranslation();
    pTrans.translation.setValue(new SbVec3f(0, 0, .499f));

    SoPolygonOffset pFaceOffset = new SoPolygonOffset();
    pFaceOffset.styles.setValue(SoPolygonOffset.StyleType.FILLED);
    pFaceOffset.units.setValue( -5);
    SoPolygonOffset pLineOffset = new SoPolygonOffset();
    pLineOffset.styles.setValue(SoPolygonOffset.StyleType.LINES);
    pLineOffset.units.setValue( -10);

    // Build the legend scene graph
    {
      addChild(pTrans);
      //addChild(pLegTex1);
      //addChild(pLegFace1);
      addChild(pFaceOffset);
      addChild(m_legTex2);
      addChild(pLegFace2);
      addChild(new SoTexture2()); // Turn off texturing before drawing lines
      addChild(pLineOffset);
      addChild(pLegLine);
    }

    // Setup to monitor this transfer function
    m_sliceXferSensor = new SoNodeSensor();
    m_sliceXferSensor.setTask(new ColorMapSensorTask(m_sliceXferSensor));
    m_sliceXferSensor.attach(m_sliceTransferFunction);

    m_XferSensor = new SoNodeSensor();
    m_XferSensor.setTask(new ColorMapSensorTask(m_XferSensor));
    m_XferSensor.attach(m_XferNode);
  }

  public void updateColorMapLegend(SoTransferFunction pXferNode) {
    // Allocate a 256x1 4-component texture image for colormap
    //
    // TODO: Make this more general (won't always be 256 values!)

    ByteBuffer buffer = pXferNode.getPackedColorMap(0);
    int length = buffer.capacity();
    byte[] pImage = new byte[length];
    for (int i = 0; i < length; i++)
      pImage[i] = buffer.get();

    m_legTex2.image.setValue(new SbVec2s((short)256, (short)1), 4, pImage);
  }

  class ColorMapSensorTask implements Runnable {
    SoNodeSensor pNodeSensor;
    public ColorMapSensorTask(SoNodeSensor sensor) {
      pNodeSensor = sensor;
    }
    public void run() {
      SoTransferFunction pXferNode =
          (SoTransferFunction) pNodeSensor.getAttachedNode();
      if (pXferNode != null)
        updateColorMapLegend(pXferNode);
    }
  }
}

