package volumeviz.advanced.volRend;

import java.io.File;

import javax.swing.SpringLayout;


public class DataSetPanel extends VolRendPanel {

  private String[] m_items = {
      "3DHead   (ldm) 256x256x109x8",
      "Virus    (am)  50x50x50x8",
      "Brill    (am)  122x122x122x8",
      "CThead8  (am)  128x128x128x8",
      "CThead16 (am)  128x128x128x16",
      "agipAVS  (fld) 128x128x128x8",
      "SYN_64   (vol) 64x64x64x8",
      "3DHead   (vol) 256x256x109x8",
      "Engine   (vol) 256x256x110x8",
      "Lobster  (vol) 320x320x34x8",
      "Colt     (vol) 300x455x91x8",
      "User filename"
  };

  private ChooserPanel m_chooserPanel;
  private VolRend m_volRend;
  private VolRendPanel[] m_panels;

  public DataSetPanel(VolRend vol_rend, VolRendPanel[] panels) {
    super("DATASET");

    m_volRend = vol_rend;
    m_panels = panels;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  private void jbInit() throws Exception {
    m_chooserPanel = new ChooserPanel(m_items, new File(VolRend.m_filePrefix + "bonsai.am"));
    m_chooserPanel.addComboBoxListener(new DataComboBoxListener());

    SpringLayout layout = new SpringLayout();
    setLayout(layout);
    add(m_chooserPanel);

    layout.putConstraint(SpringLayout.WEST, m_chooserPanel, 5,
                         SpringLayout.WEST, this);
    layout.putConstraint(SpringLayout.NORTH, m_chooserPanel, 10,
                         SpringLayout.NORTH, this);
  }

  private void reInitPanel() {
    for(int i = 0; i < m_panels.length; i++)
      m_panels[i].reset();
    m_volRend.m_viewer.viewAll();
    m_volRend.m_viewer.getRenderArea().saveCamera();;
  }

  private void changeFile(File new_file) {
    if (!new_file.exists())
      System.err.println("Unable to locate data file " + new_file.getName());
    else {
      System.out.println("Loading data file " + new_file.getName());
      m_volRend.doDataChange(new_file);
      reInitPanel();
    }
  }

  class DataComboBoxListener implements ChooserComboBoxListener {
    public void itemSelectedChanged(int selected_index) {
      File new_file;
      if (selected_index == m_items.length - 1)
        new_file = m_chooserPanel.getUserFile();
      else
        new_file = new File(VolRend.m_filePrefix + m_volRend.m_fileNames[selected_index]);
      changeFile(new_file);
    }
  }
}
