package volumeviz.advanced.volRend;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.volumeviz.nodes.SoVolumeRender.SamplingAlignments;

public class GeomControlPanel extends VolRendPanel
{

  private static final String[] SAMPLING_ALIGNMENTS = { "View aligned", "Data aligned", "Boundary aligned",
      "Smooth Boundary aligned" };

  private VolRend m_volRend;
  private SliderPanel m_slices;

  public GeomControlPanel(VolRend vol_rend) {
    super("GEOMETRY CONTROL");
    m_volRend = vol_rend;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    JLabel samplingAlignmentLabel = new JLabel("Sampling Alignment");
    JComboBox<String> samplingAlignmentBox = new JComboBox<>(SAMPLING_ALIGNMENTS);
    samplingAlignmentBox.setSelectedIndex(m_volRend.m_volRenderSwitch.m_volRend.samplingAlignment.getValue());
    samplingAlignmentBox.addActionListener(new SamplingAlignmentListener());
    JPanel samplingAlignmentPanel = new JPanel();
    samplingAlignmentPanel.add(samplingAlignmentLabel);
    samplingAlignmentPanel.add(samplingAlignmentBox);

    m_slices = new SliderPanel(0, 0, 0);
    m_slices.addInfoText("Number of Slices");
    m_slices.setInfoTextSize(new Dimension(110, 31));
    m_slices.addSliderPanelListener(new SlicesListener());
    reset();

    SpringLayout sp_layout = new SpringLayout();
    setLayout(sp_layout);
    add(samplingAlignmentPanel);
    add(m_slices);

    sp_layout.putConstraint(SpringLayout.NORTH, m_slices, 20,
                            SpringLayout.SOUTH, samplingAlignmentPanel);
  }

  public void reset() {
    int nb_slices;
    int vol_width = m_volRend.m_volData.data.getSize().getX();
    if (vol_width > 200) {
      nb_slices = 200;
      m_volRend.m_volRenderSwitch.m_volRend.numSlices.setValue(nb_slices);
    }
    else if (vol_width > 100) {
      nb_slices = 70;
      m_volRend.m_volRenderSwitch.m_volRend.numSlices.setValue(nb_slices);
    }
    else
      nb_slices = 0;
    m_slices.setSliderMax(vol_width);
    m_slices.setSliderValue(nb_slices);
  }

  class SamplingAlignmentListener implements ActionListener
  {
    public void actionPerformed(ActionEvent e)
    {
      int selectedItem = ((JComboBox<?>) e.getSource()).getSelectedIndex();
      switch ( selectedItem )
      {
      case 0 :
        m_volRend.m_volRenderSwitch.m_volRend.samplingAlignment.setValue(SamplingAlignments.VIEW_ALIGNED);
        break;
      case 1 :
        m_volRend.m_volRenderSwitch.m_volRend.samplingAlignment.setValue(SamplingAlignments.DATA_ALIGNED);
        break;
      case 2 :
        m_volRend.m_volRenderSwitch.m_volRend.samplingAlignment.setValue(SamplingAlignments.BOUNDARY_ALIGNED);
        break;
      case 3 :
        m_volRend.m_volRenderSwitch.m_volRend.samplingAlignment.setValue(SamplingAlignments.SMOOTH_BOUNDARY_ALIGNED);
        break;
      }
    }
  }

  class SlicesListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_volRend.m_volRenderSwitch.m_volRend.numSlices.setValue((int)value);
    }
  }
}
