package volumeviz.advanced.volRend;

import java.awt.Dimension;

import javax.swing.SpringLayout;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.ldm.nodes.SoLDMResourceParameters;
import com.openinventor.volumeviz.nodes.SoVolumeData;

public class MemControlPanel extends VolRendPanel {
  private SliderPanel m_mainMemoryMb;
  private SoVolumeData m_volData;

  public MemControlPanel(SoVolumeData vol_data) {
    super("MAIN MEMORY CONTROL PARAMETERS");
    m_volData = vol_data;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    Dimension label_dim = new Dimension(105, 31);

    m_mainMemoryMb = new SliderPanel(1, 512, 256);
    m_mainMemoryMb.addInfoText("Amount in MB");
    m_mainMemoryMb.setInfoTextSize(label_dim);
    m_mainMemoryMb.addSliderPanelListener(new MainMemoryMbListener());

    SliderPanel notify_rate = new SliderPanel(1, 100, 50);
    notify_rate.addInfoText("Notification Rate");
    notify_rate.setInfoTextSize(label_dim);
    notify_rate.addSliderPanelListener(new NotifyRateListener());

    SpringLayout sp_layout = new SpringLayout();
    setLayout(sp_layout);
    add(m_mainMemoryMb);
    add(notify_rate);

    sp_layout.putConstraint(SpringLayout.NORTH, m_mainMemoryMb, 5,
                            SpringLayout.NORTH, this);
    sp_layout.putConstraint(SpringLayout.NORTH, notify_rate, 10,
                            SpringLayout.SOUTH, m_mainMemoryMb);
  }

  class MainMemoryMbListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
    	SoLDMResourceParameters resParams = m_volData.ldmResourceParameters.getValue();
      resParams.maxMainMemory.setValue((int)value);
    }
  }

  class NotifyRateListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_volData.ldmResourceParameters.getValue().loadNotificationRate.setValue((int)value);
    }
  }
}
