package volumeviz.advanced.volRend;

import com.openinventor.inventor.nodes.*;
import com.openinventor.volumeviz.nodes.*;
import com.openinventor.inventor.fields.*;
import com.openinventor.inventor.*;

public class ROIBBoxSwitch extends SoSwitch {

  private SoVolumeData m_volData;
  private BBoxSeparator m_bboxRoot;
  private SoSFBox3i32 m_box;
  private float m_xFactor, m_yFactor, m_zFactor;
  private SbBox3f m_volBounds;

  public ROIBBoxSwitch(SoVolumeData vol_data, SoSFBox3i32 box, SbColor color) {
    super();
    m_volData = vol_data;
    m_box = box;
    m_volData = vol_data;
    m_bboxRoot = new BBoxSeparator(color);

    updateInitTransform();
    addChild(m_bboxRoot);

    whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public void update() {
    SbVec3i32[] new_bounds = m_box.getValue().getMinMax();
    m_bboxRoot.update(new_bounds);
  }

  public void updateInitTransform() {
    m_volBounds = m_volData.extent.getValue();
    SbVec3f volMin = m_volBounds.getMin();
    SbVec3f volMax = m_volBounds.getMax(); 
    SbVec3i32 vol_dim = m_volData.data.getSize();
    m_xFactor = (volMax.getX()-volMin.getX()) / (vol_dim.getX()-1);
    m_yFactor = (volMax.getY()-volMin.getY()) / (vol_dim.getY()-1);
    m_zFactor = (volMax.getZ()-volMin.getZ()) / (vol_dim.getZ()-1);

    m_bboxRoot.setScaleFactor(m_xFactor, m_yFactor, m_zFactor);
    m_bboxRoot.setTranslation(volMin);
  }

  public void resetTranslation() {
    m_bboxRoot.setTranslation(m_volBounds.getMin());
  }

  public void setTranslation(SbVec3f trans) {
    m_bboxRoot.setTranslation(trans);
  }

  public float[] getBBoxBounds() {
    return m_bboxRoot.getBBoxBounds();
  }
}
