package volumeviz.advanced.volRend; 
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class SliceColormapPanel extends ColormapPanel {

  private VolRend m_volRend;

  public SliceColormapPanel(VolRend vol_rend) {
    super("SLICE COLORMAP", 5);

    m_volRend = vol_rend;

    m_colormapChooser.addComboBoxListener(new SliceCmapComboBoxListener());
    m_colormapMin.addSliderPanelListener(new ColormapMinSliderListener());
    m_colormapMin.setSliderValue(1);
    m_colormapMax.addSliderPanelListener(new ColormapMaxSliderListener());
    m_opaqueMin.addSliderPanelListener(new OpaqueMinSliderListener());
    m_opaqueMin.setSliderValue(1);
    m_opaqueMax.addSliderPanelListener(new OpaqueMaxSliderListener());
    m_invert.addItemListener(new InvertListener());
  }

  private void updateMap() {
  	m_volRend.m_sliceTransferFunction.enableNotify(false);
    m_volRend.m_sliceTransferFunction.minValue.setValue(VolRend.m_minSliceColorMap);
    m_volRend.m_sliceTransferFunction.maxValue.setValue(VolRend.m_maxSliceColorMap);
    m_volRend.m_sliceTransferFunction.enableNotify(true);
    m_volRend.m_sliceTransferFunction.touch();

    m_volRend.updateOpaqueRegion( m_volRend.m_sliceTransferFunction, VolRend.m_minSliceOpaqueMap,
                                 VolRend.m_maxSliceOpaqueMap,
                                 VolRend.m_invertSliceTransparency);
    m_volRend.m_infoSep.createHistoLegend(1);
  }

  class SliceCmapComboBoxListener implements ChooserComboBoxListener {
    public void itemSelectedChanged(int selected_index) {
      if (selected_index == m_comboBoxItems.length - 1)
        m_volRend.m_userColorMapName = m_colormapChooser.getUserFile().getAbsolutePath();
      m_volRend.doCmapChange(selected_index, m_volRend.m_sliceTransferFunction);
    }
  }

  class ColormapMinSliderListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      if (value > VolRend.m_maxSliceColorMap)
        System.err.println("Colormap Max < Colormap Min : impossible");
      else {
        // Remap colormap, then re-apply min/max opaque values
        VolRend.m_minSliceColorMap = (int)value;
        updateMap();
      }
    }
  }

  class ColormapMaxSliderListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      if (value < VolRend.m_minSliceColorMap)
        System.err.println("Colormap Max < Colormap Min : impossible");
      else {
        // Remap colormap, then re-apply min/max opaque values
        VolRend.m_maxSliceColorMap = (int)value;
        updateMap();
      }
    }
  }

  class OpaqueMinSliderListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      if (value > VolRend.m_maxSliceOpaqueMap)
        System.err.println("Opaque Max < Opaque Min : impossible");
      else {
        // Remap colormap, then re-apply min/max opaque values
        VolRend.m_minSliceOpaqueMap = (int)value;
        updateMap();
      }
    }
  }

  class OpaqueMaxSliderListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      if (value < VolRend.m_minSliceOpaqueMap)
        System.err.println("Opaque Max < Opaque Min : impossible");
      else {
        // Remap colormap, then re-apply min/max opaque values
        VolRend.m_maxSliceOpaqueMap = (int)value;
        updateMap();
      }
    }
  }

  class InvertListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      VolRend.m_invertSliceTransparency = (e.getStateChange() == ItemEvent.SELECTED);
      updateMap();
    }
  }
}
