package volumeviz.advanced.volRend;
import javax.swing.*;
import java.awt.*;

public class SlicePanel extends VolRendPanel {
  private String[] m_alphaTypeItems = {
      "Binary",
      "As Is",
      "Opaque"
  };

  protected OnOffButtonPanel m_visible;
  protected InterpolationPanel m_interpolation;
  protected OnOffButtonPanel m_clipping;
  protected OnOffButtonPanel m_dragger;
  protected JLabel m_alphaTypeLabel;
  protected JComboBox<String> m_alphaType;
  protected JPanel m_optionsPanel;
  protected SpringLayout m_optionsPanelLayout;

  public SlicePanel(String name) {
    super(name);

    try {
      jbInit();
    }
    catch (Exception e) {
        e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    // Buttons panel
    m_visible = new OnOffButtonPanel("Visible", false);
    m_interpolation = new InterpolationPanel();
    m_clipping = new OnOffButtonPanel("Clipping", false);
    m_dragger = new OnOffButtonPanel("Dragger", false);

    JPanel buttons_panel = new JPanel(new GridLayout(4, 1));
    buttons_panel.add(m_visible);
    buttons_panel.add(m_interpolation);
    buttons_panel.add(m_clipping);
    buttons_panel.add(m_dragger);

    // Options panel
    m_alphaTypeLabel = new JLabel("Alpha Type");
    m_alphaType = new JComboBox<>(m_alphaTypeItems);

    m_optionsPanelLayout = new SpringLayout();
    m_optionsPanel = new JPanel(m_optionsPanelLayout);
    m_optionsPanel.add(m_alphaTypeLabel);
    m_optionsPanel.add(m_alphaType);
    Component parent = getParent();
    m_optionsPanelLayout.putConstraint(SpringLayout.NORTH, m_alphaTypeLabel, 13,
                         SpringLayout.NORTH, parent);
    m_optionsPanelLayout.putConstraint(SpringLayout.WEST, m_alphaTypeLabel, 5,
                         SpringLayout.WEST, parent);
    m_optionsPanelLayout.putConstraint(SpringLayout.NORTH, m_alphaType, 10,
                         SpringLayout.NORTH, parent);
    m_optionsPanelLayout.putConstraint(SpringLayout.WEST, m_alphaType, 47,
                         SpringLayout.EAST, m_alphaTypeLabel);

    setLayout(new BorderLayout());
    add(buttons_panel, BorderLayout.NORTH);
    add(m_optionsPanel, BorderLayout.CENTER);
  }
}
