package volumeviz.advanced.volRend;
import java.io.*;

public class UserColorMap {
  int m_numEntries;
  int m_numComps;
  String m_filename;
  float[] m_values;

  public UserColorMap(String filename) {
    m_filename = filename;
    m_values = null;
    m_numEntries = 0;
    m_numComps = 0;

    loadColorTable();
  }

  private void loadClut1999(FileReader file_reader) {
    BufferedReader b = new BufferedReader(file_reader);
    int numEntries = 0;

    try {
      // Get first line of file and confirm identity
      if (b.readLine() != "Clut1999") {
        return;
      }

      // Get the rest of the header
      String s = b.readLine();
      if (s != null || (numEntries = Integer.valueOf(s).intValue()) == 0)
        return; // Error

      s = b.readLine();
      if (s == null)
        return; // Error
      s = s.split(" ")[1];
      int rgbRange = Integer.valueOf(s).intValue();

      s = b.readLine();
      if (s == null)
        return; // Error
      s = s.split(" ")[1];
      int alphaRange = Integer.valueOf(s).intValue();

      // Read to end of header
      while (true) {
        s = b.readLine();
        if (s == null)
          return; // Error
        if (s.startsWith("##"))
          break;
      }

      // Read values
      int numFloats = numEntries * 4;
      m_values = new float[numFloats];

      float rgbScale = 1.0f / (float)rgbRange;
      float alphaScale = 1.0f / (float)alphaRange;

      for (s = b.readLine(); s != null; s = b.readLine()) {
        String[] colors = s.split(" ");
        if (colors.length < 5)
          continue; // Blank line ???

        int index = Integer.valueOf(colors[0]).intValue();
        m_values[0+index*4] = Float.valueOf(colors[1]).floatValue()*rgbScale;
        m_values[1+index*4] = Float.valueOf(colors[2]).floatValue()*rgbScale;
        m_values[2+index*4] = Float.valueOf(colors[3]).floatValue()*rgbScale;
        m_values[3+index*4] = Float.valueOf(colors[4]).floatValue()*alphaScale;
      }

      b.close();
    }
    catch (Exception e) {
      e.printStackTrace();
      return;
    }

    m_numComps = 4;
    m_numEntries = numEntries;
  }

  private void loadColorTable() {
    FileReader file_reader = null;
    try {
      file_reader = new FileReader(m_filename);
    }
    catch (Exception e) {
      System.err.println("Can't open the color map file " + m_filename);
      e.printStackTrace();
      return;
    }

    BufferedReader b = new BufferedReader(file_reader);

    int num_colors = 0;
    String s;

    // Get first line of file and try to identify it.
    try {
      s = b.readLine();
      // If TeraRecon format, use specific file loader
      if (s == "Clut1999") {
        b.close();
        loadClut1999(file_reader);
      }

      num_colors = Integer.valueOf(s).intValue();
      if (num_colors <= 0)
        return;

      float[][] rgba = new float[256][4];
      int numComponents = 0;

      s = b.readLine();
      for (int i = 0; s != null && i < num_colors; i++, s = b.readLine()) {
        float[] colors = new float[4];
        String[] colors_string = s.split(" ");
        numComponents = colors_string.length;

        for (int k = 0; k < numComponents; k++)
          colors[k] = Float.valueOf(colors_string[k]).floatValue() / 65535.0f;

        switch (numComponents) {
          case 1: // A (RGB=1)
            colors[3] = colors[0];
            colors[0] = colors[1] = colors[2] = 1;
            break;
          case 3: // RGB (A=1)
            colors[3] = 1;
            break;
          case 4: // RGBA
            break;
          default: // empty line
            continue;
        }
        rgba[i][0] = colors[0];
        rgba[i][1] = colors[1];
        rgba[i][2] = colors[2];
        rgba[i][3] = colors[3];
      }
      b.close();

      int mode = 256 / num_colors;

      float[][] rgba256 = new float[256][4];
      int index = 0;
      for (int k = 0; k < num_colors; k++) {
        int k1 = k + 1;
        if (k1 >= num_colors)
          k1 = num_colors-1;
        for (int i = 0; i < mode; i++) {
          rgba256[index][0] = rgba[k][0] + (float)i/mode*(rgba[k1][0]-rgba[k][0]);
          rgba256[index][1] = rgba[k][1] + (float)i/mode*(rgba[k1][1]-rgba[k][1]);
          rgba256[index][2] = rgba[k][2] + (float)i/mode*(rgba[k1][2]-rgba[k][2]);
          rgba256[index][3] = rgba[k][3] + (float)i/mode*(rgba[k1][3]-rgba[k][3]);
          index++;
        }
      }

      m_values = new float[256*4];
      for (int i = 0, j = 0; j < m_values.length; i++) {
        m_values[j++] = rgba256[i][0];
        m_values[j++] = rgba256[i][1];
        m_values[j++] = rgba256[i][2];
        m_values[j++] = rgba256[i][3];
      }
    }
    catch (Exception ex) {
      ex.printStackTrace();
      return;
    }

    m_numComps = 4;
    m_numEntries = 256;
  }
}
