package volumeviz.advanced.volRend;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import com.openinventor.ldm.SoLDMGlobalResourceParameters;
import com.openinventor.volumeviz.nodes.*;

public class VisualFeedbackPanel extends VolRendPanel {
  private SoVolumeData m_volData;

  public VisualFeedbackPanel(SoVolumeData vol_data) {
    super("VISUAL FEEDBACK");
    m_volData = vol_data;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    JCheckBox draw_tiles = new JCheckBox("Draw Tiles", true);
    draw_tiles.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        boolean state = (e.getStateChange() == ItemEvent.SELECTED);
        SoLDMGlobalResourceParameters.setVisualFeedbackParam(SoLDMGlobalResourceParameters.VisualFeedbackParams.DRAW_TILES, state);
        m_volData.touch();
      }
    });

    JCheckBox slice_tex = new JCheckBox("Slices Tex", true);
    slice_tex.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        boolean state = (e.getStateChange() == ItemEvent.SELECTED);
        SoLDMGlobalResourceParameters.setVisualFeedbackParam(SoLDMGlobalResourceParameters.VisualFeedbackParams.DRAW_SLICES_TEX, state);
        m_volData.touch();
      }
    });

    JCheckBox fake_data = new JCheckBox("Fake Data", false);
    fake_data.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        boolean state = (e.getStateChange() == ItemEvent.SELECTED);
        SoLDMGlobalResourceParameters.setVisualFeedbackParam(SoLDMGlobalResourceParameters.VisualFeedbackParams.USE_FAKE_DATA, state);
        m_volData.touch();
      }
    });

    JCheckBox load_unload_tiles = new JCheckBox("Load / Unload Tiles", false);
    load_unload_tiles.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        boolean state = (e.getStateChange() == ItemEvent.SELECTED);
        SoLDMGlobalResourceParameters.setVisualFeedbackParam(SoLDMGlobalResourceParameters.VisualFeedbackParams.SHOW_LOAD_UNLOAD_TILES, state);
        m_volData.touch();
      }
    });

    JCheckBox tile_outline = new JCheckBox("Texture Front Outline", false);
    tile_outline.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        boolean state = (e.getStateChange() == ItemEvent.SELECTED);
        SoLDMGlobalResourceParameters.setVisualFeedbackParam(SoLDMGlobalResourceParameters.VisualFeedbackParams.DRAW_TILE_OUTLINE, state);
        m_volData.touch();
      }
    });

    JCheckBox data_outline = new JCheckBox("Data Front Outline", false);
    data_outline.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        boolean state = (e.getStateChange() == ItemEvent.SELECTED);
        SoLDMGlobalResourceParameters.setVisualFeedbackParam(SoLDMGlobalResourceParameters.VisualFeedbackParams.DRAW_TOPOLOGY, state);
        m_volData.touch();
      }
    });

    JCheckBox octree = new JCheckBox("Valuation Outline", false);
    octree.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        boolean state = (e.getStateChange() == ItemEvent.SELECTED);
        SoLDMGlobalResourceParameters.setVisualFeedbackParam(SoLDMGlobalResourceParameters.VisualFeedbackParams.SHOW_TILES_VALUATED, state);
        m_volData.touch();
      }
    });

    GridLayout layout = new GridLayout(4, 2);
    layout.setVgap(10);
    JPanel box_panel = new JPanel(layout);
    box_panel.add(draw_tiles);
    box_panel.add(tile_outline);
    box_panel.add(slice_tex);
    box_panel.add(data_outline);
    box_panel.add(fake_data);
    box_panel.add(octree);
    box_panel.add(load_unload_tiles);

    setLayout(new BorderLayout());
    add(box_panel, BorderLayout.NORTH);
  }
}
