package volumeviz.advanced.volRend;

import java.io.*;

public class VolRendOutputStream extends OutputStream {
  private MessageTextPane m_messageArea;
  private ByteArrayOutputStream m_outputStream;
  private boolean m_isError;

  public VolRendOutputStream(MessageTextPane message_area, boolean error) {
    m_messageArea = message_area;
    m_outputStream = new ByteArrayOutputStream(256);
    m_isError = error;
  }

  public void write(int b) {
    m_outputStream.write(b);
  }

  public void flush() throws IOException{
    super.flush();
    if (m_isError)
      m_messageArea.insertErrorText(new String(m_outputStream.toByteArray()));
    else
      m_messageArea.insertInfoText(new String(m_outputStream.toByteArray()));
    m_outputStream.reset();
  }
}
