package volumeviz.sample.bonesMuscles;

import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseButtonEvent.Buttons;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.SoEventCallback;
import com.openinventor.ldm.nodes.SoDataRange;

public class MouseEventsCB extends SoEventCallbackCB
{
  private boolean leftMousePressed = false;
  private int horizVal;
  private int vertiVal;
  private SoDataRange localDataRange;

  public MouseEventsCB(SoDataRange dataRange) {
    this.localDataRange = dataRange;
  }

  @Override
  public void invoke(SoEventCallback eventCB)
  {
    SoEvent event = eventCB.getEvent();
    if (event instanceof SoMouseButtonEvent)
      mouseButtonEvent(eventCB);
    else
      mouseMoveEvent(eventCB);
  }

  private void mouseButtonEvent(SoEventCallback eventCB) {
    if ( SoMouseButtonEvent.isButtonPressEvent(eventCB.getEvent(), Buttons.BUTTON1) )
    {
      leftMousePressed  = true;
      eventCB.setHandled();
    }
    else
    {
      leftMousePressed = false;
    }
  }

  private void mouseMoveEvent(SoEventCallback eventCB) 
  {
    if ( !leftMousePressed ) return;

    SbVec2s myVec2s = eventCB.getEvent().getPosition();

    double minVal = localDataRange.min.getValue();
    if ( myVec2s.getValueAt(0) > horizVal )
    {
      minVal += 20;
    }
    if ( myVec2s.getValueAt(0) < horizVal )
    {
      minVal -= 20;
    }

    localDataRange.min.setValue(minVal);
    horizVal = myVec2s.getValueAt(0);

    double maxVal = localDataRange.max.getValue();
    if ( myVec2s.getValueAt(1) > vertiVal )
    {
      maxVal += 10;
    }
    if ( myVec2s.getValueAt(1) < vertiVal )
    {
      maxVal -= 10;
    }

    localDataRange.max.setValue(maxVal);
    vertiVal = myVec2s.getValueAt(1);
  }
}
