/*----------------------------------------------------------------------------------------
 * Example program.
 * Purpose : Demonstrate how to implement a custom SoLDMConverter with a custom SoVolumeReader
 * author : Jean-Michel Godinaud
 /*----------------------------------------------------------------------------------------*/
package volumeviz.sample.genericConverter.withGenericReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

import com.openinventor.inventor.SbBox2i32;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.devices.SoBufferObject.AccessModes;
import com.openinventor.inventor.devices.SoCpuBufferObject;
import com.openinventor.ldm.converters.SoConverterParameters;
import com.openinventor.ldm.nodes.SoDataSet.DataTypes;
import com.openinventor.volumeviz.converters.SoVolumeConverter;
import com.openinventor.volumeviz.nodes.SoVolumeData;

import util.Example;

public class Main extends Example
{

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Data Converter");
  }

  @Override
  public void start()
  {
    String fileName = "$OIVJHOME/data/volumeviz/bonsai2.raw";

    String argss[] = new String[4];
    argss[0] = " ";
    argss[1] = fileName;
    argss[2] = "-o";
    argss[3] = "./bonsai2.ldm";

    SoConverterParameters params = SoConverterParameters.create(argss);
    GenericConverter converter = new GenericConverter();
    converter.setReader(new GenericReader(fileName));

    try {
      converter.convert(params);
    } catch (Exception e) {
      System.out.println(e.getClass().getName() + " : " + e.getMessage());
    }

  }

  @Override
  public void stop()
  {}

  public class GenericConverter extends SoVolumeConverter {
    public GenericConverter() {
      super();
    }

    @Override
    public boolean progress( int numTilesGenerated, int numTilesToGenerate ) {
      System.out.println("---> progress : " + numTilesGenerated + "/" + numTilesToGenerate);
      return true;
    }

    @Override
    public String getXmlTags() {
      return "<myTags></myTags>\n";
    }

  }

  public class GenericReader extends com.openinventor.ldm.readers.SoVolumeReader {
    private SbBox3f m_size;
    private SbVec3i32 m_dim;
    private int m_type;
    private int m_bytesPerVoxel;
    private int m_headerSize;
    private RandomAccessFile m_dataFile;

    public GenericReader(String fileName)
    {
      m_size = new SbBox3f(0,0,0, 10,10,10);
      m_dim =  new SbVec3i32(256,256,256);
      m_type = SoVolumeData.DataTypes.UNSIGNED_BYTE.getValue();
      m_bytesPerVoxel = 1;
      m_headerSize = 0;
      try {
        m_dataFile = new RandomAccessFile(fileName,"r");
      } catch (Exception e) {
      }
    }

    @Override
    public DataInfo getDataChar()
    {
    	DataInfo dataInfo = new DataInfo();
    	dataInfo.dim = m_dim;
    	dataInfo.size = m_size;
    	dataInfo.type = DataTypes.valueOf(m_type);
    	dataInfo.readError = ReadErrors.RD_NO_ERROR;

    	return dataInfo;
    }

    @Override
    public void getSubSlice( SbBox2i32 subSlice, int sliceNumber, SoBufferObject bufferObject) {

      long lineSize = m_dim.getX() * m_bytesPerVoxel;
      long sliceSize = m_dim.getY() * lineSize;

      long offset = m_headerSize + sliceNumber*sliceSize
        + (subSlice.getMin()).getY()*lineSize
        + (long)(subSlice.getMin()).getX()*m_bytesPerVoxel;

      int dataToRead = ((subSlice.getMax()).getX() - (subSlice.getMin()).getX() + 1)
        * m_bytesPerVoxel;

      SoCpuBufferObject cpuBufObj = new SoCpuBufferObject();
      bufferObject.map(cpuBufObj, AccessModes.SET);

      byte[] data_src = new byte[dataToRead];
      ByteBuffer data_dest = cpuBufObj.map(AccessModes.SET);
      data_dest.rewind();

      try {
        for (int i = (subSlice.getMin()).getY();
             i <= (subSlice.getMax()).getY();
             i++) {

          m_dataFile.seek(offset);
          m_dataFile.read(data_src);

          data_dest.put(data_src);

          offset += lineSize;
        }
      } catch (Exception e) {
      }

    }
  }


}

