package volumeviz.sample.getLDMData.getDataBox;

import java.nio.ByteBuffer;

import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbDataType;
import com.openinventor.inventor.SbDataType.DataTypes;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.devices.SoCpuBufferObject;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.*;
import com.openinventor.ldm.SoLDMDataAccess;
import com.openinventor.ldm.nodes.SoLDMResourceParameters;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;

import volumeviz.sample.getLDMData.LDMData;

public class Main extends LDMData {

  boolean  m_updateData = false;

  SoVolumeData m_volData = null;
  SoSwitch m_switchViewData = null;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("GetDataBox");
  }

  @Override
  public void start() {
    super.start();

    /****** Viewer1 *******/
    // Track the keyboard events
    m_eventCB.addEventCallback(SoKeyboardEvent.class, new DataBoxKeyEventCB(), null);

    viewer1Settings();

    /********* Viewer 2 ********/
    SoText2 menu;
    { // menu
      menu = new SoText2();
      menu.string.set1Value(0, "U       : Update data");
      menu.string.set1Value(1, "UP      : Increase resolution");
      menu.string.set1Value(2, "DOWN    : Decrease resolution");
    }
    {
      menuSettings();
      m_root2.addChild(menu);
      m_root2.addChild(m_root3);
    }

    setUpViewers();
  }

  @Override
  protected void updateView2() {
    //do not display while moving
    if (m_switchViewData != null)
      m_switchViewData.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);

    SbVec3i32 dim = m_pVolData.data.getSize();
    SbBox3i32 box = new SbBox3i32(m_pROIManip.subVolume.getValue().getMin(),
                              m_pROIManip.subVolume.getValue().getMax());
    SoLDMDataAccess.DataInfoBox info;
    info = m_pVolData.getLdmDataAccess().getData(m_resolution, box);

    SoDrawStyle lineStyle = new SoDrawStyle();
    lineStyle.style.setValue(SoDrawStyle.Styles.LINES);

    SoSeparator volSep = new SoSeparator();
    {
      SoTranslation volTr = new SoTranslation();
      volTr.translation.setValue(new SbVec3f(dim.getX() / 2.f,
                                             dim.getY() / 2.f,
                                             dim.getZ() / 2.f));

      SoBaseColor volColor = new SoBaseColor();
      volColor.rgb.setValue(0.9f, 0.9f, 0.9f);

      SoCube vol = new SoCube();
      vol.width.setValue(dim.getX());
      vol.height.setValue(dim.getY());
      vol.depth.setValue(dim.getZ());

      volSep.addChild(volTr);
      volSep.addChild(volColor);
      volSep.addChild(vol);
    }

    SbVec3i32 roiMin = box.getMin();
    SbVec3i32 roiMax = box.getMax();
    SoSeparator roiSep = new SoSeparator();
    {
      SbVec3i32 roiDim = roiMax.minus(roiMin).plus(new SbVec3i32(1, 1, 1));

      SoTranslation volTr = new SoTranslation();
      volTr.translation.setValue(new SbVec3f(roiMin.getX() +
                                             roiDim.getX() / 2.f,
                                             roiMin.getY() +
                                             roiDim.getY() / 2.f,
                                             roiMin.getZ() +
                                             roiDim.getZ() / 2.f));

      SoBaseColor roiColor = new SoBaseColor();
      roiColor.rgb.setValue(1, 0, 0);

      SoCube roi = new SoCube();
      roi.width.setValue(roiDim.getX());
      roi.height.setValue(roiDim.getY());
      roi.depth.setValue(roiDim.getZ());

      roiSep.addChild(volTr);
      roiSep.addChild(roiColor);
      roiSep.addChild(roi);
    }

    {
      m_root3.removeAllChildren();
      m_root3.addChild(lineStyle);
      m_root3.addChild(volSep);
      m_root3.addChild(roiSep);
    }

    if (m_updateData) {
      m_updateData = false;

      if (m_volData == null) {
        m_switchViewData = new SoSwitch();
        m_switchViewData.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        {
          SoDrawStyle volStyle = new SoDrawStyle();
          volStyle.style.setValue(SoDrawStyle.Styles.FILLED);
          m_switchViewData.addChild(volStyle);

          m_volData = new SoVolumeData();
          m_volData.ldmResourceParameters.getValue().loadPolicy.setValue(SoLDMResourceParameters.LoadPolicies.ALWAYS);
          m_switchViewData.addChild(m_volData);

          SoTransferFunction transFunc = new SoTransferFunction();
          transFunc.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.GLOW);
          transFunc.minValue.setValue(30);
          transFunc.maxValue.setValue(255);
          m_switchViewData.addChild(transFunc);

          SoVolumeRenderingQuality pVolQuality = new SoVolumeRenderingQuality();
          pVolQuality.deferredLighting.setValue(true);
          pVolQuality.preIntegrated.setValue(true);
          m_switchViewData.addChild(pVolQuality);

          SoVolumeRender pVolRender = new SoVolumeRender();
          m_switchViewData.addChild(pVolRender);
        }
        m_root2.addChild(m_switchViewData);
      }

      if ( info.bufferSize > 0 )
      {
        SoCpuBufferObject cpuBufferObject = new SoCpuBufferObject();
        cpuBufferObject.setSize(info.bufferSize);
        info = m_pVolData.getLdmDataAccess().getData(m_resolution, box, cpuBufferObject);

        ByteBuffer buffer = cpuBufferObject.map(SoCpuBufferObject.AccessModes.READ_ONLY);
        m_volData.data.setValue(info.bufferDimension, new SbDataType(DataTypes.UNSIGNED_BYTE), buffer);
        cpuBufferObject.unmap();
      }

      m_volData.extent.setValue(new SbBox3f(roiMin.getX(), roiMin.getY(),
                                          roiMin.getZ(),
                                          roiMax.getX(), roiMax.getY(),
                                          roiMax.getZ()));

      if (m_switchViewData != null)
        m_switchViewData.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    if (m_firstTime) {
      m_viewer2.viewAll();
      m_firstTime = false;
    }
  }

  class DataBoxKeyEventCB extends SoEventCallbackCB {
    @Override
    public void invoke(SoEventCallback e) {
      SoKeyboardEvent key_event = (SoKeyboardEvent) e.getEvent();

      if (SoKeyboardEvent.isKeyPressEvent(key_event, key_event.getKey())) {
        switch (key_event.getKey()) {
          case U:
            // Update data
            m_updateData = true;
            break;
          case UP_ARROW:
            // increase resolution
            if (m_resolution > 0)
              m_resolution--;
            m_updateData = true;
            break;
          case DOWN_ARROW:
            // decrease resolution
            m_resolution++;
            m_updateData = true;
            break;
          default:
            return;
        }
        m_pROIManip.touch(); // to force viewer2 to be updated
      }
    }
  }
}
