package volumeviz.sample.getLDMData.getDataPlane;

import com.openinventor.inventor.*;
import com.openinventor.inventor.devices.SoCpuBufferObject;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.fields.SoSFImage;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.*;
import com.openinventor.ldm.SoLDMDataAccess;

import volumeviz.sample.getLDMData.LDMData;

public class Main extends LDMData {

  boolean m_toggleInterpolation = true;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("GetDataPlane");
  }

  @Override
  public void start() {
    super.start();

    /********* Viewer1 *********/
    // Track the keyboard events
    m_eventCB.addEventCallback(SoKeyboardEvent.class, new DataPlaneKeyEventCB(), null);

    addJackDragger(new SbRotation(new SbVec3f(1, 0, 0), 1.570796325f));
    viewer1Settings();

    /********* Viewer2 *********/
    SoText2 menu;
    { // menu
      menu = new SoText2();
      menu.string.set1Value(0, "D   : Toggle data");
      menu.string.set1Value(1, "I   : Toggle interpolation");
      menu.string.set1Value(2, "UP  : Increase resolution");
      menu.string.set1Value(3, "DOWN: Decrease resolution");
      menu.string.set1Value(4, "XYZ : Axis alignment");
    }
    {
      menuSettings();
      m_root2.addChild(menu);
      m_root2.addChild(m_root3);
    }

    setUpViewers();
  }

  @Override
  protected void updateView2() {
    SbVec3i32 dim = m_pVolData.getDimension();

    SbPlane plane;
    { // get plane
      SbVec3f planePosition = m_planeDragger.translation.getValue();

      // rotate the plane's normal by the dragger rotation
      SbRotation rotation = m_planeDragger.rotation.getValue();
      SbVec3f planeNormal = new SbVec3f();
      planeNormal = rotation.multVec(new SbVec3f(0, 1, 0));
      plane = new SbPlane(planeNormal, planePosition);

      // plane equation in data coordinates
      SbMatrix mx = new SbMatrix();
      mx.makeIdentity();
      SbVec3f volmin = m_pVolData.extent.getValue().getMin();
      SbVec3f volmax = m_pVolData.extent.getValue().getMax();
      mx.setElement(0, 0, dim.getX() / (volmax.getX() - volmin.getX()));
      mx.setElement(0, 3, -mx.getElement(0, 0)* volmin.getX());
      mx.setElement(1, 1, dim.getY() / (volmax.getY() - volmin.getY()));
      mx.setElement(1, 3, -mx.getElement(1, 1) * volmin.getY());
      mx.setElement(2, 2, dim.getZ() / (volmax.getZ() - volmin.getZ()));
      mx.setElement(2, 3, -mx.getElement(2, 2) * volmin.getZ());
      plane.transform(mx);
    }

    SbBox3i32 box = new SbBox3i32(m_pROIManip.subVolume.getValue().getMin(),
                              m_pROIManip.subVolume.getValue().getMax());

    SoLDMDataAccess.DataInfoPlane info =
        m_pVolData.getLdmDataAccess().getData(m_resolution, box, plane);

    SoDrawStyle lineStyle = new SoDrawStyle();
    lineStyle.style.setValue(SoDrawStyle.Styles.LINES);

    SoSeparator volSep = new SoSeparator();
    {
      SoTranslation volTr = new SoTranslation();
      volTr.translation.setValue(dim.getX() / 2.f,
                                 dim.getY() / 2.f,
                                 dim.getZ() / 2.f);

      SoBaseColor volColor = new SoBaseColor();
      volColor.rgb.setValue(0.9f, 0.9f, 0.9f);

      SoCube vol = new SoCube();
      vol.width.setValue(dim.getX());
      vol.height.setValue(dim.getY());
      vol.depth.setValue(dim.getZ());

      volSep.addChild(volTr);
      volSep.addChild(volColor);
      volSep.addChild(vol);
    }

    SoSeparator roiSep = new SoSeparator();
    {
      SbVec3i32 roiMin = box.getMin();
      SbVec3i32 tmp = box.getMax();
      tmp.substract(roiMin);
      SbVec3i32 roiDim = tmp.plus(new SbVec3i32(1, 1, 1));

      SoTranslation volTr = new SoTranslation();
      volTr.translation.setValue(roiMin.getX() + roiDim.getX() / 2.f,
                                  roiMin.getY() + roiDim.getY() / 2.f,
                                  roiMin.getZ() + roiDim.getZ() / 2.f);

      SoBaseColor roiColor = new SoBaseColor();
      roiColor.rgb.setValue(1, 0, 0);

      SoCube roi = new SoCube();
      roi.width.setValue(roiDim.getX());
      roi.height.setValue(roiDim.getY());
      roi.depth.setValue(roiDim.getZ());

      roiSep.addChild(volTr);
      roiSep.addChild(roiColor);
      roiSep.addChild(roi);
    }

    {
      m_root3.removeAllChildren();
      m_root3.addChild(lineStyle);
      m_root3.addChild(volSep);
      m_root3.addChild(roiSep);
    }

    if (info.numPolygonPoints > 0) {
      SbVec3f []vertices = new SbVec3f[6];
      for (int i = 0; i < 6; i++)
        vertices[i] = new SbVec3f();

      SoBaseColor quadColor = new SoBaseColor();
      quadColor.rgb.setValue(0.3f, 0.7f, 0.5f);

      SoFaceSet quad = new SoFaceSet();
      for (int i = 0; i < 4; i++) {
        vertices[i].setX(info.quadCoord[i].getX());
        vertices[i].setY(info.quadCoord[i].getY());
        vertices[i].setZ(info.quadCoord[i].getZ());
      }
      SoVertexProperty vp = new SoVertexProperty();
      vp.vertex.setValues(0, vertices);
      quad.vertexProperty.setValue(vp);
      quad.numVertices.set1Value(0, 4);

      SoBaseColor polygonColor = new SoBaseColor();
      polygonColor.rgb.setValue(1.0f, 0.8f, 0.6f);

      SoDrawStyle lineWidthStyle = new SoDrawStyle();
      lineWidthStyle.style.setValue(SoDrawStyle.Styles.LINES);
      lineWidthStyle.lineWidth.setValue(5.f);

      SoFaceSet polygon = new SoFaceSet();
      for (int i = 0; i < info.numPolygonPoints; i++) {
        vertices[i].setX(info.polygonCoord[i].getX());
        vertices[i].setY(info.polygonCoord[i].getY());
        vertices[i].setZ(info.polygonCoord[i].getZ());
      }
      vp = new SoVertexProperty();
      vp.vertex.setValues(0, vertices);
      polygon.vertexProperty.setValue(vp);
      polygon.numVertices.set1Value(0, info.numPolygonPoints);

      {
        m_root3.addChild(quadColor);
        m_root3.addChild(quad);
        m_root3.addChild(polygonColor);
        m_root3.addChild(lineWidthStyle);
        m_root3.addChild(polygon);
      }
    }

    if (m_toggleViewData && info.bufferSize > 0) {
      SoCpuBufferObject cpuBufferObject = new SoCpuBufferObject();
      cpuBufferObject.setSize(info.bufferSize);
      info = m_pVolData.getLdmDataAccess().getData(m_resolution, box, plane, cpuBufferObject);

      SoComplexity complexity = new SoComplexity();
      if (m_toggleInterpolation)
        complexity.textureQuality.setValue(1);
      else
        complexity.textureQuality.setValue(0.1f);

      SoTexture2 tex2 = new SoTexture2();
      if ( info.errorFlag == SoLDMDataAccess.ErrorValues.CORRECT.getValue() )
        tex2.image.setValue(info.bufferDimension, 1, SoSFImage.DataTypes.UNSIGNED_BYTE, cpuBufferObject,
            SoSFImage.CopyPolicies.NO_COPY);

      SoBaseColor texColor = new SoBaseColor();
      texColor.rgb.setValue(1.0f, 1.0f, 1.0f);

      SoDrawStyle texStyle = new SoDrawStyle();
      texStyle.style.setValue(SoDrawStyle.Styles.FILLED);
      texStyle.lineWidth.setValue(5.f);

      SoFaceSet texpolygon = new SoFaceSet();
      SbVec3i32[] quad = info.quadCoord;
      SbVec2f u = new SbVec2f(quad[1].getValueAt(info.uAxis) -
                              quad[0].getValueAt(info.uAxis),
                              quad[1].getValueAt(info.vAxis) -
                              quad[0].getValueAt(info.vAxis));
      SbVec2f v = new SbVec2f(quad[2].getValueAt(info.uAxis) -
                              quad[1].getValueAt(info.uAxis),
                              quad[2].getValueAt(info.vAxis) -
                              quad[1].getValueAt(info.vAxis));
      u.multiply(1.f / u.dot(u));
      v.multiply(1.f / v.dot(v));
      SbVec3f[] vertices = new SbVec3f[6];
      SbVec2f[] texcoord = new SbVec2f[6];

      for (int i = 0; i < 6; i++) {
        vertices[i] = new SbVec3f();
        texcoord[i] = new SbVec2f();
      }

      for (int i = 0; i < info.numPolygonPoints; i++) {
        vertices[i].setX(info.polygonCoord[i].getX());
        vertices[i].setY(info.polygonCoord[i].getY());
        vertices[i].setZ(info.polygonCoord[i].getZ());
        SbVec2f uv = new SbVec2f(vertices[i].getValueAt(info.uAxis) -
                                 quad[0].getValueAt(info.uAxis),
                                 vertices[i].getValueAt(info.vAxis) -
                                 quad[0].getValueAt(info.vAxis));
        texcoord[i].setValueAt(0, uv.dot(u));
        texcoord[i].setY(uv.dot(v));
      }
      SoVertexProperty vp = new SoVertexProperty();
      vp.vertex.setValues(0, vertices);
      vp.texCoord.setValues(0, texcoord);
      texpolygon.vertexProperty.setValue(vp);
      texpolygon.numVertices.set1Value(0, info.numPolygonPoints);

      {
        m_root3.addChild(complexity);
        m_root3.addChild(tex2);
        m_root3.addChild(texColor);
        m_root3.addChild(texStyle);
        m_root3.addChild(texpolygon);
      }
    }
    if (m_firstTime) {
      m_viewer2.viewAll();
      m_firstTime = false;
    }
  }

  class DataPlaneKeyEventCB extends SoEventCallbackCB {
    @Override
    public void invoke(SoEventCallback e) {
      SoKeyboardEvent key_event = (SoKeyboardEvent)e.getEvent();

      if (SoKeyboardEvent.isKeyPressEvent(key_event, key_event.getKey())) {
        switch (key_event.getKey()) {
          case D:
            m_toggleViewData = !m_toggleViewData;
            break;
          case I:
            m_toggleInterpolation = !m_toggleInterpolation;
            break;
          case UP_ARROW:
            if (m_resolution > 0)
              m_resolution--;
            break;
          case DOWN_ARROW:
            m_resolution++;
            break;
          case X:
            m_planeDragger.rotation.setValue(new SbRotation(new SbVec3f(0, 0, 1),
                1.570796325f));
            break;
          case Y:
            m_planeDragger.rotation.setValue(new SbRotation(new SbVec3f(0, 1, 0),
                1.570796325f));
            break;
          case Z:
            m_planeDragger.rotation.setValue(new SbRotation(new SbVec3f(1, 0, 0),
                1.570796325f));
            break;
          default:
            return;
        }
        m_pROIManip.touch();
      }
    }
  }
}
