package volumeviz.sample.roiManip;

import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.*;
import com.openinventor.inventor.fields.*;
import com.openinventor.volumeviz.nodes.*;

public class BBoxSwitch extends SoSwitch {

  private SoSeparator m_bboxRoot;
  private SoTransform m_transform;
  private SoSFBox3i32 m_box;
  private SbColor m_color;
  private SoIndexedLineSet m_line;

  private float[] m_volBounds;
  private float[] m_bboxBounds;
  private float m_xFactor, m_yFactor, m_zFactor;

  public BBoxSwitch(SoVolumeData vol_data, SoSFBox3i32 box, SbColor color) {
    super();

    m_box = box;
    m_color = color;
    m_bboxBounds = new float[6];
    whichChild.setValue(SoSwitch.SO_SWITCH_NONE);

    m_bboxRoot = new SoSeparator();
    addChild(m_bboxRoot);

    SoDrawStyle pStyle = new SoDrawStyle();
    pStyle.lineWidth.setValue(2);

    SoLightModel pLMod = new SoLightModel();
    pLMod.model.setValue(SoLightModel.Models.BASE_COLOR);

    m_transform = new SoTransform();
    m_volBounds = vol_data.extent.getValue().getBounds();
    SbVec3i32 vol_dim = vol_data.data.getSize();

    m_xFactor = (m_volBounds[3]-m_volBounds[0]) / (vol_dim.getX()-1);
    m_yFactor = (m_volBounds[4]-m_volBounds[1]) / (vol_dim.getY()-1);
    m_zFactor = (m_volBounds[5]-m_volBounds[2]) / (vol_dim.getZ()-1);
    m_transform.scaleFactor.setValue(m_xFactor, m_yFactor, m_zFactor);

    m_transform.translation.setValue(m_volBounds[0], m_volBounds[1], m_volBounds[2]);

    m_line = new SoIndexedLineSet();

    m_bboxRoot.addChild(pStyle);
    m_bboxRoot.addChild(pLMod);
    m_bboxRoot.addChild(m_transform);
    m_bboxRoot.addChild(m_line);
  }

  public void update() {
    SoVertexProperty pProp = new SoVertexProperty();
    int[] bounds = m_box.getValue().getBounds();

    pProp.vertex.setNum(8);
    pProp.vertex.set1Value(0, bounds[0], bounds[1], bounds[2]);
    pProp.vertex.set1Value(1, bounds[3], bounds[1], bounds[2]);
    pProp.vertex.set1Value(2, bounds[3], bounds[4], bounds[2]);
    pProp.vertex.set1Value(3, bounds[0], bounds[4], bounds[2]);
    pProp.vertex.set1Value(4, bounds[0], bounds[1], bounds[5]);
    pProp.vertex.set1Value(5, bounds[3], bounds[1], bounds[5]);
    pProp.vertex.set1Value(6, bounds[3], bounds[4], bounds[5]);
    pProp.vertex.set1Value(7, bounds[0], bounds[4], bounds[5]);
    pProp.orderedRGBA.set1Value(0, m_color.getPackedValue());

    int[] indices = {
        0, 1, 2, 3, 0, -1,
        4, 5, 6, 7, 4, -1,
        0, 4, -1,
        1, 5, -1,
        2, 6, -1,
        3, 7, -1
    };

    m_line.vertexProperty.setValue(pProp);
    m_line.coordIndex.setValues(0, indices);

    m_bboxBounds[0] = bounds[0]*m_xFactor + m_volBounds[0];
    m_bboxBounds[1] = bounds[1]*m_yFactor + m_volBounds[1];
    m_bboxBounds[2] = bounds[2]*m_zFactor + m_volBounds[2];
    m_bboxBounds[3] = bounds[3]*m_xFactor + m_volBounds[0];
    m_bboxBounds[4] = bounds[4]*m_yFactor + m_volBounds[1];
    m_bboxBounds[5] = bounds[5]*m_zFactor + m_volBounds[2];
  }

  public void setTranslation(float xTrans, float yTrans, float zTrans) {
    m_transform.translation.setValue(xTrans, yTrans, zTrans);
  }

  public void resetTranslation(){
    m_transform.translation.setValue(m_volBounds[0], m_volBounds[1], m_volBounds[2]);
  }

  public float[] getBBoxBounds() {
    return m_bboxBounds;
  }
}

