package volumeviz.tools.ldmConverter;

import com.openinventor.ldm.converters.SoConverterParameters;
import com.openinventor.volumeviz.converters.SoVolumeConverter;

//@formatter:off
/**
 * Allows converting a volume data file to an LDM format file for VolumeViz
 *
 * Parameters:
 * - source volume filename
 * - tile dimension (power of 2). Default is 64x64x64.
 * - destination filename. Default is the source filename with extension .ldm.
 * - amount of main memory to do not exceed. Default is 512 Mb.
 * - option to indicate to output the xml header only...
 *
 * Execute this program without any parameters to show the full help text. Also
 * see the help pages for SoConverter.
 *
 */
//@formatter:on
public class LDMConverter
{

  public static void main(String[] args)
  {
    SoVolumeConverter myConverter = new SoVolumeConverter();
    SoConverterParameters myConverterParameters = null;

    if ( args.length > 0 )
      myConverterParameters = SoConverterParameters.create(args);

    int ret = myConverter.convert(myConverterParameters);

    System.exit(ret);

  }

}
