/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef VVIZBLENDING_FRAG_H
#define VVIZBLENDING_FRAG_H

/* Returns true if src should ne considered as first hit (used to set depth of pixel) */
bool VVizIsFirstBlend(in bool hasHit,in vec4 dest, in vec4 src);

/* Return true if alpha should be considered as first hitBoundary (regardingopacityThreshold) */
bool VVizIsFirstBoundary(in bool hasHitBoundary, in float curStep, in float alpha);

/* Returns true if calling VVizBlendEquation(dest,src) would impact result */
bool VVizHasBlendImpact(in vec4 dest, in vec4 src);

/* Returns the color resulting of dest and src blending */
vec4 VVizBlendEquation(in vec4 dest, in vec4 src);

/* Return true if dest cannot be blend more (used to stop raycast) */
bool VVizBlendMaxReached(in vec4 dest);

#endif
