/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef VVIZOUTPUTCOLOR_FRAG_H
#define VVIZOUTPUTCOLOR_FRAG_H

/**
 * @ingroup VolumeVizFragmentShaders
 * This function sends the final fragment color to OpenGL. @BR
 * It should be used instead of directly setting gl_FragColor, in order to
 * allow VolumeViz to do final manipulation of the color.
 *
 * Should be used at the end of FRAGMENT_MAIN shader only.
 *
 * @param color the color to render.
 */
void VVizOutputColor(vec4 color);

// Internal
// color: final VR output color
// firstHitBoundary: depth of boundary
// colorUntilBoundary: accumulated color until we reached boundary
// nprData: Edge detect datas.
// worldVertex: 1st hit point expressed in world space.
void VVizOutputColor(vec4 color, float firstHitBoundary, vec4 colorUntilBoundary, vec4 nprData, vec4 worldVertex);

#endif


