/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef VVIZFNC_VERT_H
#define VVIZFNC_VERT_H

/**
 * Set VVizVertex to gl_Vertex for compatibility with OIV6.
 * Must be called by all OIV6 functions using VVizVertex
 */
void VVizOIV6VertexCompatibility();


/**
 * Returns the current vertex being processed. @BR
 * Returns gl_Vertex. It should be the first function called in the main vertex shader.
 */
vec4 VVizGenerateVertex();


/**
 *  Computes object linear texture coordinates using planes defined by VolumeViz in texture unit 0. @BR
 *    Texture coordinates computed are relative to the current tile.
 *    These coordinates are normally used in the fragment shader to look up the voxel data
 *    value for the current fragment.
 */
vec3 VVizTexGen(vec4 vert);

/**
 *  Computes object linear texture
 *    coordinates using planes defined by VolumeViz in texture unit 1. @BR
 *    Texture coordinates computed are relative to the entire volume.
 *    These coordinates may be used in a fragment shader when the position of the voxel
 *    in the volume is needed. The volume dimensions in voxels are available to the
 *    shader in the (vec3) VVizVolumeDimensions uniform parameter.
 */
vec3 VVizTexGenVol(vec4 vert);

vec3 VVizComputeViewDir();
void VVizComputeBackSliceTexCoordPerspective();

/**
 *  Same as VVizComputeBackSliceTexCoord but with an orthographic camera.
 */
void VVizComputeBackSliceTexCoordOrtho();

/**
 *  Puts the texture coordinates of the
 *  back slice into gl_TexCoord[1]. @BR These coordinates allow you to retrieve the volume data
 *  which is in the alignment of the eye and the front slice volume data. In the picture
 *  below, the texture coordinates of Sf will be in gl_TexCoord[0] and those of Sb in
 *  gl_TexCoord[1]. This function only works in view-aligned slice mode.
 *  @IMAGE schema_slices.jpg
 */
void VVizComputeBackSliceTexCoord();

/**
 * Puts the texture coordinates of the front slice into gl_TexCoord[0].
 * These coordinates are used for indexing the volume data texture. 
 */
void VVizComputeFrontSliceTexCoord();

//Compute lighting vector when multivolume is off.
void VVizComputeLightingVectorsNoMultiVolume();

//Compute lighting vector when multivolume is on.
//Vertices are in view space and must be transformed back to object space
void VVizComputeLightingVectorsMultiVolume();

void VVizComputeLightingVectorsPerspective();

//Compute lighting vector when multivolume is off.
void VVizComputeLightingVectorsOrthoNoMultiVolume();

//Compute lighting vector when multivolume is on.
//Vertices are in view space and must be transformed back to object space
void VVizComputeLightingVectorsOrthoMultiVolume();


/**
 * This function must be called in your vertex @I main @i function 
 * if you are using bump mapping node.
 *
 */
void VVizComputeTangentToEyeSpaceMatrix();

/**
 * Same as VVizComputeLightingVectors but with an orthographic camera.
 */
void VVizComputeLightingVectorsOrtho();

/**
 * Computes the following lighting vectors:
 *         - @I VVizLightingVec@i: directional light vector in object space. The first directional
 *                                    light found in the scene graph is used for this computation.
 *         - @I VVizViewVec@i: vertex to eye vector in object space
 *         - @I VVizHalfVec@i: half vector in object space (VVizViewVec+VVizLightingVec)/2
 */
void VVizComputeLightingVectors();

/** Helper function to fetch a texel at a specific LOD */
vec4 VVizTextureLod(sampler3D tex, vec3 tcoord, float mipLevel);

/** Helper function to fetch a texel at a specific LOD */
vec4 VVizTextureLod(sampler2D tex, vec2 tcoord, float mipLevel);

/**
 * @ingroup VolumeVizFragmentShaders
 * Compute the luminance of a voxel value.
 * @param data value to convert
 * @return Luminance of data.
 */
float VVizGetLuminance(VVIZ_DATATYPE data);

#endif


