package com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Hashtable;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.viewercomponents.SoEventBuilder;

public class AWTEventToSoEvent
{

  private static Hashtable<Integer, SoKeyboardEvent.Keys> awt2OivKey = null;

  private static SoKeyboardEvent.Keys getKeySym(int key)
  {
    if ( awt2OivKey == null )
    {
      awt2OivKey = new Hashtable<Integer, SoKeyboardEvent.Keys>();

      // @formatter:off
      Object array[] = {
          KeyEvent.VK_UNDEFINED, SoKeyboardEvent.Keys.ANY,
          KeyEvent.VK_SHIFT, SoKeyboardEvent.Keys.LEFT_SHIFT,
          KeyEvent.VK_CONTROL, SoKeyboardEvent.Keys.LEFT_CONTROL,
          KeyEvent.VK_ALT, SoKeyboardEvent.Keys.LEFT_ALT,
          KeyEvent.VK_KANA, SoKeyboardEvent.Keys.RIGHT_ALT,
          KeyEvent.VK_0, SoKeyboardEvent.Keys.NUMBER_0,
          KeyEvent.VK_1, SoKeyboardEvent.Keys.NUMBER_1,
          KeyEvent.VK_2, SoKeyboardEvent.Keys.NUMBER_2,
          KeyEvent.VK_3, SoKeyboardEvent.Keys.NUMBER_3,
          KeyEvent.VK_4, SoKeyboardEvent.Keys.NUMBER_4,
          KeyEvent.VK_5, SoKeyboardEvent.Keys.NUMBER_5,
          KeyEvent.VK_6, SoKeyboardEvent.Keys.NUMBER_6,
          KeyEvent.VK_7, SoKeyboardEvent.Keys.NUMBER_7,
          KeyEvent.VK_8, SoKeyboardEvent.Keys.NUMBER_8,
          KeyEvent.VK_9, SoKeyboardEvent.Keys.NUMBER_9,
          KeyEvent.VK_A, SoKeyboardEvent.Keys.A,
          KeyEvent.VK_B, SoKeyboardEvent.Keys.B,
          KeyEvent.VK_C, SoKeyboardEvent.Keys.C,
          KeyEvent.VK_D, SoKeyboardEvent.Keys.D,
          KeyEvent.VK_E, SoKeyboardEvent.Keys.E,
          KeyEvent.VK_F, SoKeyboardEvent.Keys.F,
          KeyEvent.VK_G, SoKeyboardEvent.Keys.G,
          KeyEvent.VK_H, SoKeyboardEvent.Keys.H,
          KeyEvent.VK_I, SoKeyboardEvent.Keys.I,
          KeyEvent.VK_J, SoKeyboardEvent.Keys.J,
          KeyEvent.VK_K, SoKeyboardEvent.Keys.K,
          KeyEvent.VK_L, SoKeyboardEvent.Keys.L,
          KeyEvent.VK_M, SoKeyboardEvent.Keys.M,
          KeyEvent.VK_N, SoKeyboardEvent.Keys.N,
          KeyEvent.VK_O, SoKeyboardEvent.Keys.O,
          KeyEvent.VK_P, SoKeyboardEvent.Keys.P,
          KeyEvent.VK_Q, SoKeyboardEvent.Keys.Q,
          KeyEvent.VK_R, SoKeyboardEvent.Keys.R,
          KeyEvent.VK_S, SoKeyboardEvent.Keys.S,
          KeyEvent.VK_T, SoKeyboardEvent.Keys.T,
          KeyEvent.VK_U, SoKeyboardEvent.Keys.U,
          KeyEvent.VK_V, SoKeyboardEvent.Keys.V,
          KeyEvent.VK_W, SoKeyboardEvent.Keys.W,
          KeyEvent.VK_X, SoKeyboardEvent.Keys.X,
          KeyEvent.VK_Y, SoKeyboardEvent.Keys.Y,
          KeyEvent.VK_Z, SoKeyboardEvent.Keys.Z,
          KeyEvent.VK_HOME, SoKeyboardEvent.Keys.HOME,
          KeyEvent.VK_LEFT, SoKeyboardEvent.Keys.LEFT_ARROW,
          KeyEvent.VK_UP, SoKeyboardEvent.Keys.UP_ARROW,
          KeyEvent.VK_RIGHT, SoKeyboardEvent.Keys.RIGHT_ARROW,
          KeyEvent.VK_DOWN, SoKeyboardEvent.Keys.DOWN_ARROW,
          KeyEvent.VK_PAGE_UP, SoKeyboardEvent.Keys.PAGE_UP,
          KeyEvent.VK_PAGE_DOWN, SoKeyboardEvent.Keys.PAGE_DOWN,
          KeyEvent.VK_META, SoKeyboardEvent.Keys.LEFT_META,
          KeyEvent.VK_END, SoKeyboardEvent.Keys.END,
          KeyEvent.VK_NUMPAD0, SoKeyboardEvent.Keys.PAD_0,
          KeyEvent.VK_NUMPAD1, SoKeyboardEvent.Keys.PAD_1,
          KeyEvent.VK_NUMPAD2, SoKeyboardEvent.Keys.PAD_2,
          KeyEvent.VK_NUMPAD3, SoKeyboardEvent.Keys.PAD_3,
          KeyEvent.VK_NUMPAD4, SoKeyboardEvent.Keys.PAD_4,
          KeyEvent.VK_NUMPAD5, SoKeyboardEvent.Keys.PAD_5,
          KeyEvent.VK_NUMPAD6, SoKeyboardEvent.Keys.PAD_6,
          KeyEvent.VK_NUMPAD7, SoKeyboardEvent.Keys.PAD_7,
          KeyEvent.VK_NUMPAD8, SoKeyboardEvent.Keys.PAD_8,
          KeyEvent.VK_NUMPAD9, SoKeyboardEvent.Keys.PAD_9,
          KeyEvent.VK_ADD, SoKeyboardEvent.Keys.PAD_ADD,
          KeyEvent.VK_SUBTRACT, SoKeyboardEvent.Keys.PAD_SUBTRACT,
          KeyEvent.VK_MULTIPLY, SoKeyboardEvent.Keys.PAD_MULTIPLY,
          KeyEvent.VK_DIVIDE, SoKeyboardEvent.Keys.PAD_DIVIDE,
          KeyEvent.VK_F1, SoKeyboardEvent.Keys.F1,
          KeyEvent.VK_F2, SoKeyboardEvent.Keys.F2,
          KeyEvent.VK_F3, SoKeyboardEvent.Keys.F3,
          KeyEvent.VK_F4, SoKeyboardEvent.Keys.F4,
          KeyEvent.VK_F5, SoKeyboardEvent.Keys.F5,
          KeyEvent.VK_F6, SoKeyboardEvent.Keys.F6,
          KeyEvent.VK_F7, SoKeyboardEvent.Keys.F7,
          KeyEvent.VK_F8, SoKeyboardEvent.Keys.F8,
          KeyEvent.VK_F9, SoKeyboardEvent.Keys.F9,
          KeyEvent.VK_F10, SoKeyboardEvent.Keys.F10,
          KeyEvent.VK_F11, SoKeyboardEvent.Keys.F11,
          KeyEvent.VK_F12, SoKeyboardEvent.Keys.F12,
          KeyEvent.VK_BACK_SPACE, SoKeyboardEvent.Keys.BACKSPACE,
          KeyEvent.VK_TAB, SoKeyboardEvent.Keys.TAB,
          KeyEvent.VK_ENTER, SoKeyboardEvent.Keys.ENTER,
          KeyEvent.VK_PAUSE, SoKeyboardEvent.Keys.PAUSE,
          KeyEvent.VK_SCROLL_LOCK, SoKeyboardEvent.Keys.SCROLL_LOCK,
          KeyEvent.VK_ESCAPE, SoKeyboardEvent.Keys.ESCAPE,
          KeyEvent.VK_DELETE, SoKeyboardEvent.Keys.KEY_DELETE,
          KeyEvent.VK_PRINTSCREEN, SoKeyboardEvent.Keys.PRINT,
          KeyEvent.VK_INSERT, SoKeyboardEvent.Keys.INSERT,
          KeyEvent.VK_NUM_LOCK, SoKeyboardEvent.Keys.NUM_LOCK,
          KeyEvent.VK_CAPS_LOCK, SoKeyboardEvent.Keys.CAPS_LOCK,
          KeyEvent.VK_SPACE, SoKeyboardEvent.Keys.SPACE,
          KeyEvent.VK_QUOTE, SoKeyboardEvent.Keys.APOSTROPHE,
          KeyEvent.VK_COMMA, SoKeyboardEvent.Keys.COMMA,
          KeyEvent.VK_PERIOD, SoKeyboardEvent.Keys.PERIOD,
          KeyEvent.VK_SLASH, SoKeyboardEvent.Keys.SLASH,
          KeyEvent.VK_SEMICOLON, SoKeyboardEvent.Keys.SEMICOLON,
          KeyEvent.VK_EQUALS, SoKeyboardEvent.Keys.EQUAL,
          KeyEvent.VK_OPEN_BRACKET, SoKeyboardEvent.Keys.BRACKETLEFT,
          KeyEvent.VK_BACK_SLASH, SoKeyboardEvent.Keys.BACKSLASH,
          KeyEvent.VK_CLOSE_BRACKET, SoKeyboardEvent.Keys.BRACKETRIGHT,
          KeyEvent.VK_BACK_QUOTE, SoKeyboardEvent.Keys.GRAVE
      };
      // @formatter:on

      for ( int i = 0; i < array.length; i += 2 )
        awt2OivKey.put((Integer) array[i], (SoKeyboardEvent.Keys) array[i + 1]);

      // On macOS, the CTRL value corresponds to the META key on the keyboard,
      // and the META value corresponds to the CTRL key.
      if ( System.getProperty("os.name").toLowerCase().contains("mac") )
      {
        awt2OivKey.put((Integer)KeyEvent.VK_CONTROL, SoKeyboardEvent.Keys.LEFT_META);
        awt2OivKey.put((Integer)KeyEvent.VK_META, SoKeyboardEvent.Keys.LEFT_CONTROL);
      }

    }

    SoKeyboardEvent.Keys oivKey = awt2OivKey.get(key);
    if ( oivKey == null )
      return SoKeyboardEvent.Keys.ANY;

    return oivKey;
  }

  private static SoEventBuilder s_ivEvent = new SoEventBuilder();

  private static boolean isControlDown(InputEvent event)
  {
    // On macOS, the CTRL value corresponds to the META key on the keyboard,
    // and the META value corresponds to the CTRL key.
    if ( System.getProperty("os.name").toLowerCase().contains("mac") )
      return event.isMetaDown();
    else
      return event.isControlDown();
  }

  public static SoMouseButtonEvent getMousePressEvent(MouseEvent event, Component source)
  {
    SoMouseButtonEvent.Buttons whichButton = getButtonId(event);

    // change origin from upper corner (awt) to lower (oiv)
    int y = source.getSize().height - 1 - event.getY();

    return s_ivEvent.getMousePressEvent(event.getX(), y, whichButton, event.isAltDown(), isControlDown(event),
        event.isShiftDown());
  }

  public static SoMouseButtonEvent getMouseReleaseEvent(MouseEvent event, Component source)
  {
    SoMouseButtonEvent.Buttons whichButton = getButtonId(event);

    // change origin from upper corner (awt) to lower (oiv)
    int y = source.getSize().height - 1 - event.getY();

    return s_ivEvent.getMouseReleaseEvent(event.getX(), y, whichButton, event.isAltDown(), isControlDown(event),
        event.isShiftDown());
  }

  public static SoMouseButtonEvent getMouseDoubleClickEvent(MouseEvent event, Component source)
  {
    SoMouseButtonEvent.Buttons whichButton = getButtonId(event);

    // change origin from upper corner (awt) to lower (oiv)
    int y = source.getSize().height - 1 - event.getY();

    return s_ivEvent.getMouseDoubleClickEvent(event.getX(), y, whichButton, event.isAltDown(), isControlDown(event),
        event.isShiftDown());
  }

  private static SoMouseButtonEvent.Buttons getButtonId(MouseEvent event)
  {
    SoMouseButtonEvent.Buttons whichButton = SoMouseButtonEvent.Buttons.ANY;
    int button = event.getButton();

    switch ( button )
    {
    case MouseEvent.BUTTON1 :
      whichButton = SoMouseButtonEvent.Buttons.BUTTON1;
      break;
    case MouseEvent.BUTTON2 :
      whichButton = SoMouseButtonEvent.Buttons.BUTTON2;
      break;
    case MouseEvent.BUTTON3 :
      whichButton = SoMouseButtonEvent.Buttons.BUTTON3;
      break;
    default:
      break;
    }

    return whichButton;
  }

  public static SoMouseWheelEvent getMouseWheelEvent(MouseWheelEvent event, Component source)
  {
    // get the number of "clicks" the mouse wheel was rotated
    // negative values if the mouse wheel was rotated up/away from the user, and
    // positive values if the mouse wheel was rotated down/towards the user
    int nbClicks = event.getWheelRotation();

    // set the mouse wheel delta in OIV event.
    // A positive value indicates the wheel was rotated forward (away from the
    // user), so it's the opposite of what we get from the AWT event. The values
    // are specified in multiples of the wheel delta.
    int delta = -nbClicks * SoPreferences.getInteger("OIV_WHEEL_DELTA", 120);

    return s_ivEvent.getMouseWheelEvent(delta, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

  public static SoLocation2Event getMouseMoveEvent(MouseEvent event, Component source)
  {
    // change origin from upper corner (awt) to lower (oiv)
    Dimension dim = source.getSize();
    int y = dim.height - 1 - event.getY();

    return s_ivEvent.getMouseMoveEvent(event.getX(), y, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

  public static SoLocation2Event getMouseEnterEvent(MouseEvent event, Component source)
  {
    // change origin from upper corner (awt) to lower (oiv)
    Dimension dim = source.getSize();
    int y = dim.height - 1 - event.getY();

    return s_ivEvent.getMouseEnterEvent(event.getX(), y, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

  public static SoLocation2Event getMouseLeaveEvent(MouseEvent event, Component source)
  {
    // change origin from upper corner (awt) to lower (oiv)
    Dimension dim = source.getSize();
    int y = dim.height - 1 - event.getY();

    return s_ivEvent.getMouseLeaveEvent(event.getX(), y, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

  public static SoKeyboardEvent getKeyPressEvent(KeyEvent event, Component source)
  {
    SoKeyboardEvent.Keys whichKey = getKeySym(event.getKeyCode());

    return s_ivEvent.getKeyPressEvent(whichKey, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

  public static SoKeyboardEvent getKeyReleaseEvent(KeyEvent event, Component source)
  {
    SoKeyboardEvent.Keys whichKey = getKeySym(event.getKeyCode());

    return s_ivEvent.getKeyReleaseEvent(whichKey, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

}
