package com.openinventor.inventor.viewercomponents.awt.newt.viewers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.*;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive.ClippingPlanesAdjustMode;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.awt.tools.PreferencesDialog;
import com.openinventor.inventor.viewercomponents.awt.tools.PreferencesDialog.GeneralPreferencesListener;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionModeListener;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor.CameraMode;

public class ViewerExaminer extends JPanel implements IViewerExaminer
{

  private RenderAreaExaminer m_renderArea;

  private JToggleButton m_seekButton;

  public ViewerExaminer()
  {
    // build an examiner render area with stereo support
    m_renderArea = new RenderAreaExaminer(true);
    m_renderArea.addInteractionModeListener(new InteractionModeListener()
    {
      @Override
      public void seekModeChanged(boolean onOrOff)
      {
        m_seekButton.setSelected(onOrOff);
      }

      @Override
      public void interactionModeChanged(InteractionMode newMode)
      {
        updateUI(m_renderArea.getInteractionMode());
      }
    });

    JPanel viewerPanel = new JPanel(new BorderLayout());
    viewerPanel.add(m_renderArea);

    JPanel toolsPanel = buildToolsPanel();

    updateUI(m_renderArea.getInteractionMode());

    setLayout(new BorderLayout());
    add(viewerPanel, BorderLayout.CENTER);
    add(toolsPanel, BorderLayout.EAST);
  }

  @Override
  public Component getComponent()
  {
    return this;
  }

  @Override
  public void setSceneGraph(SoNode sceneGraph)
  {
    m_renderArea.setSceneGraph(sceneGraph);
  }

  @Override
  public void viewAll()
  {
    m_renderArea.viewAll(new SbViewportRegion(m_renderArea.getSize()));
  }

  @Override
  public RenderAreaExaminer getRenderArea()
  {
    return m_renderArea;
  }

  @Override
  public void dispose()
  {
    m_renderArea.dispose();
  }

  // GUI
  private void updateUI(InteractionMode activeMode)
  {
    switch ( activeMode )
    {
    case NAVIGATION :
      m_seekButton.setEnabled(true);
      break;
    case SELECTION :
      m_seekButton.setSelected(false);
      m_seekButton.setEnabled(false);
      break;
    default:
      break;
    }
  }

  private JPanel buildToolsPanel()
  {
    JPanel toolsPanel = new JPanel();
    toolsPanel.setLayout(new GridBagLayout());

    JButton resetButton = new JButton("");
    resetButton.setBorderPainted(false);
    resetButton.setContentAreaFilled(false);
    resetButton.setMargin(new Insets(0, 0, 0, 0));
    resetButton.setToolTipText("View All");
    GridBagConstraints gbc_resetButton = new GridBagConstraints();
    gbc_resetButton.fill = GridBagConstraints.HORIZONTAL;
    gbc_resetButton.gridx = 0;
    gbc_resetButton.gridy = 0;
    toolsPanel.add(resetButton, gbc_resetButton);
    resetButton.setIcon(new ImageIcon(
        this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerViewAllTech.png")));
    resetButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        viewAll();
      }
    });

    JButton xViewButton = new JButton("");
    xViewButton.setToolTipText("YZ view");
    xViewButton.setContentAreaFilled(false);
    xViewButton.setBorderPainted(false);
    xViewButton.setMargin(new Insets(0, 0, 0, 0));
    GridBagConstraints gbc_btnX = new GridBagConstraints();
    gbc_btnX.fill = GridBagConstraints.HORIZONTAL;
    gbc_btnX.gridx = 0;
    gbc_btnX.gridy = 1;
    toolsPanel.add(xViewButton, gbc_btnX);
    xViewButton.setIcon(new ImageIcon(
        this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerViewYZTech.png")));
    xViewButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        m_renderArea.viewAxis(new SbVec3f(-1, 0, 0), new SbVec3f(0, 0, 1));
        viewAll();
      }
    });

    JButton yViewButton = new JButton("");
    yViewButton.setToolTipText("XZ view");
    yViewButton.setContentAreaFilled(false);
    yViewButton.setBorderPainted(false);
    yViewButton.setMargin(new Insets(0, 0, 0, 0));
    GridBagConstraints gbc_btnY = new GridBagConstraints();
    gbc_btnY.fill = GridBagConstraints.HORIZONTAL;
    gbc_btnY.gridx = 0;
    gbc_btnY.gridy = 2;
    toolsPanel.add(yViewButton, gbc_btnY);
    yViewButton.setIcon(new ImageIcon(
        this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerViewXZTech.png")));
    yViewButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        m_renderArea.viewAxis(new SbVec3f(0, -1, 0), new SbVec3f(1, 0, 0));
        viewAll();
      }
    });

    JButton zViewButton = new JButton("");
    zViewButton.setToolTipText("XY view");
    zViewButton.setContentAreaFilled(false);
    zViewButton.setBorderPainted(false);
    zViewButton.setMargin(new Insets(0, 0, 0, 0));
    GridBagConstraints gbc_btnZ = new GridBagConstraints();
    gbc_btnZ.fill = GridBagConstraints.HORIZONTAL;
    gbc_btnZ.gridx = 0;
    gbc_btnZ.gridy = 3;
    toolsPanel.add(zViewButton, gbc_btnZ);
    zViewButton.setIcon(new ImageIcon(
        this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerViewXYTech.png")));
    zViewButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        m_renderArea.viewAxis(new SbVec3f(0, 0, -1), new SbVec3f(0, 1, 0));
        viewAll();
      }
    });

    JButton cameraRestoreButton = new JButton("");
    cameraRestoreButton.setContentAreaFilled(false);
    cameraRestoreButton.setBorderPainted(false);
    cameraRestoreButton.setMargin(new Insets(0, 0, 0, 0));
    cameraRestoreButton.setToolTipText("Restore Camera");
    GridBagConstraints gbc_cameraRestoreButton = new GridBagConstraints();
    gbc_cameraRestoreButton.fill = GridBagConstraints.HORIZONTAL;
    gbc_cameraRestoreButton.gridx = 0;
    gbc_cameraRestoreButton.gridy = 4;
    toolsPanel.add(cameraRestoreButton, gbc_cameraRestoreButton);
    cameraRestoreButton.setIcon(
        new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerHome.png")));
    cameraRestoreButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        m_renderArea.restoreCamera();
      }
    });

    JButton cameraSaveButton = new JButton("");
    cameraSaveButton.setContentAreaFilled(false);
    cameraSaveButton.setBorderPainted(false);
    cameraSaveButton.setMargin(new Insets(0, 0, 0, 0));
    cameraSaveButton.setToolTipText("Save Camera");
    GridBagConstraints gbc_cameraSaveButton = new GridBagConstraints();
    gbc_cameraSaveButton.fill = GridBagConstraints.HORIZONTAL;
    gbc_cameraSaveButton.gridx = 0;
    gbc_cameraSaveButton.gridy = 5;
    toolsPanel.add(cameraSaveButton, gbc_cameraSaveButton);
    cameraSaveButton.setIcon(new ImageIcon(
        this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerSetHome.png")));
    cameraSaveButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        m_renderArea.saveCamera();
      }
    });

    JButton orthoButton = new JButton("");
    orthoButton.setContentAreaFilled(false);
    orthoButton.setBorderPainted(false);
    orthoButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        m_renderArea.setCameraType(CameraMode.ORTHOGRAPHIC);
        // disable stereo
        PreferencesDialog.getInstance().enableStereoPreferences(false);
      }
    });
    orthoButton.setMargin(new Insets(0, 0, 0, 0));
    orthoButton.setToolTipText("Switch to orthographic camera");
    orthoButton.setIcon(new ImageIcon(
        this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerOrtho.png")));
    GridBagConstraints gbc_orthoButton = new GridBagConstraints();
    gbc_orthoButton.fill = GridBagConstraints.HORIZONTAL;
    gbc_orthoButton.gridx = 0;
    gbc_orthoButton.gridy = 6;
    toolsPanel.add(orthoButton, gbc_orthoButton);

    JButton perspButton = new JButton("");
    perspButton.setContentAreaFilled(false);
    perspButton.setBorderPainted(false);
    perspButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        m_renderArea.setCameraType(CameraMode.PERSPECTIVE);
        if ( m_renderArea.isStereoSupported() && m_renderArea.isRawStereoAvailable() )
        {
          // enable stereo
          PreferencesDialog.getInstance().enableStereoPreferences(true);
        }
      }
    });
    perspButton.setMargin(new Insets(0, 0, 0, 0));
    perspButton.setToolTipText("Switch to perspective camera");
    perspButton.setIcon(new ImageIcon(
        this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerPerspective.png")));
    GridBagConstraints gbc_perspButton = new GridBagConstraints();
    gbc_perspButton.fill = GridBagConstraints.HORIZONTAL;
    gbc_perspButton.gridx = 0;
    gbc_perspButton.gridy = 7;
    toolsPanel.add(perspButton, gbc_perspButton);

    m_seekButton = new JToggleButton("", false);
    m_seekButton.setContentAreaFilled(false);
    m_seekButton.setBorderPainted(false);
    m_seekButton.setMargin(new Insets(0, 0, 0, 0));
    m_seekButton.setToolTipText("Seek");
    GridBagConstraints gbc_seekButton = new GridBagConstraints();
    gbc_seekButton.fill = GridBagConstraints.HORIZONTAL;
    gbc_seekButton.gridx = 0;
    gbc_seekButton.gridy = 8;
    toolsPanel.add(m_seekButton, gbc_seekButton);
    m_seekButton.setIcon(
        new ImageIcon(this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/ViewerSeek.png")));
    m_seekButton.addItemListener(new ItemListener()
    {

      @Override
      public void itemStateChanged(ItemEvent e)
      {
        m_renderArea.setSeekMode(e.getStateChange() == ItemEvent.SELECTED);
      }
    });

    JButton preferencesButton = new JButton("");
    preferencesButton.setContentAreaFilled(false);
    preferencesButton.setBorderPainted(false);
    preferencesButton.setMargin(new Insets(0, 0, 0, 0));
    preferencesButton.setToolTipText("Preferences...");
    GridBagConstraints gbc_preferencesButton = new GridBagConstraints();
    gbc_preferencesButton.weightx = 1.0;
    gbc_preferencesButton.anchor = GridBagConstraints.SOUTH;
    gbc_preferencesButton.weighty = 1.0;
    gbc_preferencesButton.fill = GridBagConstraints.HORIZONTAL;
    gbc_preferencesButton.gridx = 0;
    gbc_preferencesButton.gridy = 9;
    toolsPanel.add(preferencesButton, gbc_preferencesButton);
    preferencesButton.setIcon(new ImageIcon(
        this.getClass().getResource("/com/openinventor/inventor/viewercomponents/icons/preferences.png")));
    preferencesButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        openPreferences();
      }
    });

    return toolsPanel;
  }

  private void openPreferences()
  {
    PreferencesDialog dialog = PreferencesDialog.getInstance();

    if ( !m_renderArea.isStereoSupported() || !m_renderArea.isRawStereoAvailable() )
    {
      // disable stereo
      PreferencesDialog.getInstance().enableStereoPreferences(false);
    }
    else if ( dialog.getStereoListener() == null )
      dialog.setStereoListener(new PreferencesDialog.StereoListener()
      {

        @Override
        public void offsetValueChanged(float value)
        {
          m_renderArea.setStereoCameraOffset(value);
        }

        @Override
        public void balanceValueChanged(float value)
        {
          m_renderArea.setStereoCameraBalance(value);
        }

        @Override
        public void activateRawStereo(boolean activated)
        {
          try
          {
            m_renderArea.activateStereo(activated);
          }
          catch (UnsupportedOperationException e)
          {
            e.printStackTrace();
          }
        }
      });

    if ( dialog.getGeneralPreferencesListener() == null )
    {
      dialog.setNavigationMode(m_renderArea.getNavigationMode());
      dialog.setClippingPlanesAdjustMode(m_renderArea.getClippingPlanesAdjustMode().toString());
      dialog.setGeneralPreferencesListener(new GeneralPreferencesListener()
      {
        @Override
        public void navigationModeChanged(NavigationMode newMode)
        {
          m_renderArea.setNavigationMode(newMode);
        }

        @Override
        public void clippingModeChanged(String newMode)
        {
          m_renderArea.setClippingPlanesAdjustMode(ClippingPlanesAdjustMode.valueOf(newMode));
        }
      });
    }
    dialog.setVisible(true);
  }
}
