package com.openinventor.inventor.viewercomponents.swt;

import org.eclipse.swt.widgets.Display;

import com.openinventor.inventor.sensors.SoSystemTimer;
import com.openinventor.inventor.sensors.SoSystemTimerTask;

/**
 * Implementation of SoSystemTimer for SWT application.
 *
 */
public class Timer extends SoSystemTimer
{

  private TimerRunnable m_timerRunnable;
  private SoSystemTimerTask m_task;
  private boolean m_isRepeat;
  private int m_delay;
  private boolean m_isPending;

  public Timer()
  {
    m_timerRunnable = new TimerRunnable();
    m_task = null;
    m_isRepeat = false;
    m_delay = 0;
    m_isPending = false;
  }

  @Override
  public void start()
  {
    Display.getDefault().timerExec(m_delay, m_timerRunnable);
    setPending(true);
  }

  @Override
  public void stop()
  {
    Display.getDefault().timerExec(-1, m_timerRunnable);
    setPending(false);
  }

  private synchronized int getDelay()
  {
    return m_delay;
  }

  @Override
  public synchronized void setDelay(int time)
  {
    m_delay = time;
  }

  @Override
  public synchronized boolean isPending()
  {
    return m_isPending;
  }

  private synchronized void setPending(boolean flag)
  {
    m_isPending = flag;
  }

  private synchronized boolean isRepeat()
  {
    return m_isRepeat;
  }

  @Override
  public void setRepeat(boolean flag)
  {
    m_isRepeat = flag;
  }

  @Override
  public void setTask(SoSystemTimerTask task)
  {
    m_task = task;
  }

  private class TimerRunnable implements Runnable
  {
    @Override
    public void run()
    {
      if ( m_task != null )
        m_task.run();
      setPending(false);

      if ( isRepeat() )
        Display.getDefault().timerExec(getDelay(), this);
    }
  }
}
