package com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas;

import org.eclipse.swt.widgets.Composite;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionModeListener;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;

/**
 * Class to render an OpenInventor scene graph in a SWT GLCanvas.
 * This class extends RenderAreaInteractive to add examiner viewer behaviors.
 * <p>
 * Note: When using this component, the automatic interactive mode is disabled,
 * see
 * {@link com.openinventor.inventor.SoSceneManager#setAutoInteractiveMode(boolean)}
 * for more details. Interactive mode is managed by the SceneExaminer node.
 */
public class RenderAreaExaminer extends RenderAreaInteractive
{

  private SceneExaminer m_examinerRootSceneGraph;

  public RenderAreaExaminer(Composite parent, int style)
  {
    super(parent, style, false);

    init();
  }

  public RenderAreaExaminer(Composite parent, int style, GLCapabilities caps)
  {
    super(parent, style, false, caps);

    init();
  }

  private void init()
  {
    // Disable SceneExaminer automatic adjustment of clipping planes,
    // adjustment is managed by the render area.
    SoPreferences.setValue("OIV_SCENE_EXAMINER_AUTO_CLIPPING_PLANES", "false");
    m_rootSceneGraph = m_examinerRootSceneGraph = new SceneExaminer();

    buildSceneGraph();
  }

  @Override
  public void init(GLAutoDrawable drawable)
  {
    super.init(drawable);

    // Deactivate auto interactive mode,
    // interactive mode is managed by the SceneExaminer.
    m_renderAreaCore.getSceneManager().setAutoInteractiveMode(false);
  }

  public void setSeekMode(boolean onOrOff)
  {
    m_examinerRootSceneGraph.setSeekMode(onOrOff);
  }

  public void setNavigationMode(NavigationMode mode)
  {
    m_examinerRootSceneGraph.setNavigationMode(mode);
  }

  public NavigationMode getNavigationMode()
  {
    return m_examinerRootSceneGraph.getNavigationMode();
  }

  public InteractionMode getInteractionMode()
  {
    return m_examinerRootSceneGraph.getInteractionMode();
  }

  public void addInteractionModeListener(InteractionModeListener listener)
  {
    m_examinerRootSceneGraph.addInteractionModeListener(listener);
  }

  public void removeInteractionModeListener(InteractionModeListener listener)
  {
    m_examinerRootSceneGraph.removeInteractionModeListener(listener);
  }

  /**
   * @deprecated As of Open Inventor 10.5.0, use {@link #getSceneInteractor} instead.
   */
  @Deprecated
  @Override
  public SceneExaminer getRootSceneGraph()
  {
    return m_examinerRootSceneGraph;
  }

  @Override
  public SceneExaminer getSceneInteractor()
  {
    return m_examinerRootSceneGraph;
  }

}
