/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.viewercomponents.SoEventBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Hashtable;

public class AWTEventToSoEvent {
    private static Hashtable<Integer, SoKeyboardEvent.Keys> awt2OivKey = null;
    private static SoEventBuilder s_ivEvent = new SoEventBuilder();

    private static SoKeyboardEvent.Keys getKeySym(int n) {
        Object[] objectArray;
        if (awt2OivKey == null) {
            awt2OivKey = new Hashtable();
            objectArray = new Object[]{0, SoKeyboardEvent.Keys.ANY, 16, SoKeyboardEvent.Keys.LEFT_SHIFT, 17, SoKeyboardEvent.Keys.LEFT_CONTROL, 18, SoKeyboardEvent.Keys.LEFT_ALT, 21, SoKeyboardEvent.Keys.RIGHT_ALT, 48, SoKeyboardEvent.Keys.NUMBER_0, 49, SoKeyboardEvent.Keys.NUMBER_1, 50, SoKeyboardEvent.Keys.NUMBER_2, 51, SoKeyboardEvent.Keys.NUMBER_3, 52, SoKeyboardEvent.Keys.NUMBER_4, 53, SoKeyboardEvent.Keys.NUMBER_5, 54, SoKeyboardEvent.Keys.NUMBER_6, 55, SoKeyboardEvent.Keys.NUMBER_7, 56, SoKeyboardEvent.Keys.NUMBER_8, 57, SoKeyboardEvent.Keys.NUMBER_9, 65, SoKeyboardEvent.Keys.A, 66, SoKeyboardEvent.Keys.B, 67, SoKeyboardEvent.Keys.C, 68, SoKeyboardEvent.Keys.D, 69, SoKeyboardEvent.Keys.E, 70, SoKeyboardEvent.Keys.F, 71, SoKeyboardEvent.Keys.G, 72, SoKeyboardEvent.Keys.H, 73, SoKeyboardEvent.Keys.I, 74, SoKeyboardEvent.Keys.J, 75, SoKeyboardEvent.Keys.K, 76, SoKeyboardEvent.Keys.L, 77, SoKeyboardEvent.Keys.M, 78, SoKeyboardEvent.Keys.N, 79, SoKeyboardEvent.Keys.O, 80, SoKeyboardEvent.Keys.P, 81, SoKeyboardEvent.Keys.Q, 82, SoKeyboardEvent.Keys.R, 83, SoKeyboardEvent.Keys.S, 84, SoKeyboardEvent.Keys.T, 85, SoKeyboardEvent.Keys.U, 86, SoKeyboardEvent.Keys.V, 87, SoKeyboardEvent.Keys.W, 88, SoKeyboardEvent.Keys.X, 89, SoKeyboardEvent.Keys.Y, 90, SoKeyboardEvent.Keys.Z, 36, SoKeyboardEvent.Keys.HOME, 37, SoKeyboardEvent.Keys.LEFT_ARROW, 38, SoKeyboardEvent.Keys.UP_ARROW, 39, SoKeyboardEvent.Keys.RIGHT_ARROW, 40, SoKeyboardEvent.Keys.DOWN_ARROW, 33, SoKeyboardEvent.Keys.PAGE_UP, 34, SoKeyboardEvent.Keys.PAGE_DOWN, 157, SoKeyboardEvent.Keys.LEFT_META, 35, SoKeyboardEvent.Keys.END, 96, SoKeyboardEvent.Keys.PAD_0, 97, SoKeyboardEvent.Keys.PAD_1, 98, SoKeyboardEvent.Keys.PAD_2, 99, SoKeyboardEvent.Keys.PAD_3, 100, SoKeyboardEvent.Keys.PAD_4, 101, SoKeyboardEvent.Keys.PAD_5, 102, SoKeyboardEvent.Keys.PAD_6, 103, SoKeyboardEvent.Keys.PAD_7, 104, SoKeyboardEvent.Keys.PAD_8, 105, SoKeyboardEvent.Keys.PAD_9, 107, SoKeyboardEvent.Keys.PAD_ADD, 109, SoKeyboardEvent.Keys.PAD_SUBTRACT, 106, SoKeyboardEvent.Keys.PAD_MULTIPLY, 111, SoKeyboardEvent.Keys.PAD_DIVIDE, 112, SoKeyboardEvent.Keys.F1, 113, SoKeyboardEvent.Keys.F2, 114, SoKeyboardEvent.Keys.F3, 115, SoKeyboardEvent.Keys.F4, 116, SoKeyboardEvent.Keys.F5, 117, SoKeyboardEvent.Keys.F6, 118, SoKeyboardEvent.Keys.F7, 119, SoKeyboardEvent.Keys.F8, 120, SoKeyboardEvent.Keys.F9, 121, SoKeyboardEvent.Keys.F10, 122, SoKeyboardEvent.Keys.F11, 123, SoKeyboardEvent.Keys.F12, 8, SoKeyboardEvent.Keys.BACKSPACE, 9, SoKeyboardEvent.Keys.TAB, 10, SoKeyboardEvent.Keys.ENTER, 19, SoKeyboardEvent.Keys.PAUSE, 145, SoKeyboardEvent.Keys.SCROLL_LOCK, 27, SoKeyboardEvent.Keys.ESCAPE, 127, SoKeyboardEvent.Keys.KEY_DELETE, 154, SoKeyboardEvent.Keys.PRINT, 155, SoKeyboardEvent.Keys.INSERT, 144, SoKeyboardEvent.Keys.NUM_LOCK, 20, SoKeyboardEvent.Keys.CAPS_LOCK, 32, SoKeyboardEvent.Keys.SPACE, 222, SoKeyboardEvent.Keys.APOSTROPHE, 44, SoKeyboardEvent.Keys.COMMA, 46, SoKeyboardEvent.Keys.PERIOD, 47, SoKeyboardEvent.Keys.SLASH, 59, SoKeyboardEvent.Keys.SEMICOLON, 61, SoKeyboardEvent.Keys.EQUAL, 91, SoKeyboardEvent.Keys.BRACKETLEFT, 92, SoKeyboardEvent.Keys.BACKSLASH, 93, SoKeyboardEvent.Keys.BRACKETRIGHT, 192, SoKeyboardEvent.Keys.GRAVE};
            for (int i = 0; i < objectArray.length; i += 2) {
                awt2OivKey.put((Integer)objectArray[i], (SoKeyboardEvent.Keys)objectArray[i + 1]);
            }
            if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                awt2OivKey.put(17, SoKeyboardEvent.Keys.LEFT_META);
                awt2OivKey.put(157, SoKeyboardEvent.Keys.LEFT_CONTROL);
            }
        }
        if ((objectArray = awt2OivKey.get(n)) == null) {
            return SoKeyboardEvent.Keys.ANY;
        }
        return objectArray;
    }

    private static boolean isControlDown(InputEvent inputEvent) {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return inputEvent.isMetaDown();
        }
        return inputEvent.isControlDown();
    }

    public static SoMouseButtonEvent getMousePressEvent(MouseEvent mouseEvent, Component component) {
        SoMouseButtonEvent.Buttons buttons = AWTEventToSoEvent.getButtonId(mouseEvent);
        int n = component.getSize().height - 1 - mouseEvent.getY();
        return s_ivEvent.getMousePressEvent(mouseEvent.getX(), n, buttons, mouseEvent.isAltDown(), AWTEventToSoEvent.isControlDown(mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoMouseButtonEvent getMouseReleaseEvent(MouseEvent mouseEvent, Component component) {
        SoMouseButtonEvent.Buttons buttons = AWTEventToSoEvent.getButtonId(mouseEvent);
        int n = component.getSize().height - 1 - mouseEvent.getY();
        return s_ivEvent.getMouseReleaseEvent(mouseEvent.getX(), n, buttons, mouseEvent.isAltDown(), AWTEventToSoEvent.isControlDown(mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoMouseButtonEvent getMouseDoubleClickEvent(MouseEvent mouseEvent, Component component) {
        SoMouseButtonEvent.Buttons buttons = AWTEventToSoEvent.getButtonId(mouseEvent);
        int n = component.getSize().height - 1 - mouseEvent.getY();
        return s_ivEvent.getMouseDoubleClickEvent(mouseEvent.getX(), n, buttons, mouseEvent.isAltDown(), AWTEventToSoEvent.isControlDown(mouseEvent), mouseEvent.isShiftDown());
    }

    private static SoMouseButtonEvent.Buttons getButtonId(MouseEvent mouseEvent) {
        SoMouseButtonEvent.Buttons buttons = SoMouseButtonEvent.Buttons.ANY;
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) != 0) {
            buttons = SoMouseButtonEvent.Buttons.BUTTON1;
        } else if ((n & 8) != 0) {
            buttons = SoMouseButtonEvent.Buttons.BUTTON2;
        } else if ((n & 4) != 0) {
            buttons = SoMouseButtonEvent.Buttons.BUTTON3;
        }
        return buttons;
    }

    public static SoMouseWheelEvent getMouseWheelEvent(MouseWheelEvent mouseWheelEvent, Component component) {
        int n = mouseWheelEvent.getWheelRotation();
        int n2 = -n * SoPreferences.getInteger((String)"OIV_WHEEL_DELTA", (int)120);
        return s_ivEvent.getMouseWheelEvent(n2, mouseWheelEvent.isAltDown(), AWTEventToSoEvent.isControlDown(mouseWheelEvent), mouseWheelEvent.isShiftDown());
    }

    public static SoLocation2Event getMouseMoveEvent(MouseEvent mouseEvent, Component component) {
        Dimension dimension = component.getSize();
        int n = dimension.height - 1 - mouseEvent.getY();
        return s_ivEvent.getMouseMoveEvent(mouseEvent.getX(), n, mouseEvent.isAltDown(), AWTEventToSoEvent.isControlDown(mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoLocation2Event getMouseEnterEvent(MouseEvent mouseEvent, Component component) {
        Dimension dimension = component.getSize();
        int n = dimension.height - 1 - mouseEvent.getY();
        return s_ivEvent.getMouseEnterEvent(mouseEvent.getX(), n, mouseEvent.isAltDown(), AWTEventToSoEvent.isControlDown(mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoLocation2Event getMouseLeaveEvent(MouseEvent mouseEvent, Component component) {
        Dimension dimension = component.getSize();
        int n = dimension.height - 1 - mouseEvent.getY();
        return s_ivEvent.getMouseLeaveEvent(mouseEvent.getX(), n, mouseEvent.isAltDown(), AWTEventToSoEvent.isControlDown(mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoKeyboardEvent getKeyPressEvent(KeyEvent keyEvent, Component component) {
        SoKeyboardEvent.Keys keys = AWTEventToSoEvent.getKeySym(keyEvent.getKeyCode());
        return s_ivEvent.getKeyPressEvent(keys, keyEvent.isAltDown(), AWTEventToSoEvent.isControlDown(keyEvent), keyEvent.isShiftDown());
    }

    public static SoKeyboardEvent getKeyReleaseEvent(KeyEvent keyEvent, Component component) {
        SoKeyboardEvent.Keys keys = AWTEventToSoEvent.getKeySym(keyEvent.getKeyCode());
        return s_ivEvent.getKeyReleaseEvent(keys, keyEvent.isAltDown(), AWTEventToSoEvent.isControlDown(keyEvent), keyEvent.isShiftDown());
    }
}

