/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.devices.SoGLContext;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.sensors.SoSystemTimer;
import com.openinventor.inventor.viewercomponents.SoRawStereoParameters;
import com.openinventor.inventor.viewercomponents.SoRenderAreaCore;
import com.openinventor.inventor.viewercomponents.SoStereoParameters;
import com.openinventor.inventor.viewercomponents.awt.IRenderArea;
import com.openinventor.inventor.viewercomponents.awt.Timer;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.OptionalStereoGLCapabilitiesChooser;
import java.awt.Canvas;
import java.awt.GraphicsDevice;

public class RenderArea
extends GLCanvas
implements GLEventListener,
IRenderArea {
    protected SoRenderAreaCore m_renderAreaCore = null;
    protected SoNode m_sceneGraph = null;
    protected SoGLRenderAction.TransparencyTypes m_transparencyType;
    private SoGLRenderAction m_glRenderAction;

    public RenderArea() {
        this(null, (GLCapabilitiesChooser)new OptionalStereoGLCapabilitiesChooser(), null);
    }

    public RenderArea(GLCapabilities gLCapabilities) {
        this((GLCapabilitiesImmutable)gLCapabilities, (GLCapabilitiesChooser)new OptionalStereoGLCapabilitiesChooser(), null);
    }

    private RenderArea(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        super(gLCapabilitiesImmutable, gLCapabilitiesChooser, graphicsDevice);
        SoDB.setSystemTimer((SoSystemTimer)new Timer());
        this.addGLEventListener(this);
        this.m_transparencyType = SoGLRenderAction.TransparencyTypes.BLEND;
        this.m_glRenderAction = null;
    }

    @Override
    public void setTransparencyType(SoGLRenderAction.TransparencyTypes transparencyTypes) {
        this.m_transparencyType = transparencyTypes;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setTransparencyType(this.m_transparencyType);
        }
    }

    @Override
    public SoGLRenderAction.TransparencyTypes getTransparencyType() {
        return this.m_transparencyType;
    }

    @Override
    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.m_glRenderAction = soGLRenderAction;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.getSceneManager().setGLRenderAction(soGLRenderAction);
        }
    }

    @Override
    public SoGLRenderAction getGLRenderAction() {
        return this.m_glRenderAction;
    }

    @Override
    public void activateStereo(boolean bl) {
        if (bl) {
            if (!this.isRawStereoAvailable()) {
                throw new UnsupportedOperationException("Stereo buffers are not enabled");
            }
            SoRawStereoParameters soRawStereoParameters = new SoRawStereoParameters();
            this.m_renderAreaCore.setStereoParameters((SoStereoParameters)soRawStereoParameters);
            this.m_renderAreaCore.activateStereo(true);
        } else {
            this.m_renderAreaCore.activateStereo(false);
        }
    }

    @Override
    public boolean isRawStereoAvailable() {
        return this.getChosenGLCapabilities().getStereo();
    }

    @Override
    public void setSceneGraph(SoNode soNode) {
        this.m_sceneGraph = soNode;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setSceneGraph(soNode);
        }
    }

    @Override
    public Canvas getComponent() {
        return this;
    }

    @Override
    public void scheduleRedraw() {
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.getSceneManager().scheduleRedraw();
        }
    }

    protected void render() {
        this.m_renderAreaCore.render();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        SoGLContext soGLContext = SoGLContext.getCurrent((boolean)true);
        this.m_renderAreaCore = new SoRenderAreaCore(soGLContext);
        this.m_renderAreaCore.setSceneGraph(this.m_sceneGraph);
        this.m_renderAreaCore.setTransparencyType(this.m_transparencyType);
        if (this.m_glRenderAction == null) {
            this.m_glRenderAction = this.m_renderAreaCore.getSceneManager().getGLRenderAction();
        } else {
            this.m_renderAreaCore.getSceneManager().setGLRenderAction(this.m_glRenderAction);
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.m_renderAreaCore.dispose();
    }

    @Override
    public void dispose() {
        this.destroy();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.render();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            return;
        }
        this.m_renderAreaCore.setSize(new SbVec2i32(n3, n4));
    }
}

