/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.openinventor.inventor.SbEventListener;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoStereoCamera;
import com.openinventor.inventor.viewercomponents.SiRenderArea;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.AWTEventToSoEvent;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderArea;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class RenderAreaInteractive
extends RenderArea
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
IRenderAreaInteractive {
    protected SceneInteractor m_rootSceneGraph;
    private SoGroup m_appSceneGraph;
    private IRenderAreaInteractive.ClippingPlanesAdjustMode m_clippingMode;

    public RenderAreaInteractive() {
        this.init(true);
    }

    public RenderAreaInteractive(GLCapabilities gLCapabilities) {
        super(gLCapabilities);
        this.init(true);
    }

    protected RenderAreaInteractive(boolean bl) {
        this.init(bl);
    }

    protected RenderAreaInteractive(boolean bl, GLCapabilities gLCapabilities) {
        super(gLCapabilities);
        this.init(bl);
    }

    private void init(boolean bl) {
        this.m_clippingMode = IRenderAreaInteractive.ClippingPlanesAdjustMode.AUTO;
        if (bl) {
            this.m_rootSceneGraph = new SceneInteractor();
            this.buildSceneGraph();
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    protected void buildSceneGraph() {
        this.m_appSceneGraph = new SoGroup();
        this.m_rootSceneGraph.addChild((SoNode)this.m_appSceneGraph);
        super.setSceneGraph((SoNode)this.m_rootSceneGraph);
    }

    @Override
    public void setSceneGraph(SoNode soNode) {
        this.m_appSceneGraph.removeAllChildren();
        if (soNode != null) {
            this.m_appSceneGraph.addChild(soNode);
        }
    }

    @Override
    protected void render() {
        if (this.m_clippingMode == IRenderAreaInteractive.ClippingPlanesAdjustMode.AUTO) {
            this.m_rootSceneGraph.adjustClippingPlanes(this.m_renderAreaCore.getSceneManager().getViewportRegion());
        }
        super.render();
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        super.init(gLAutoDrawable);
        this.m_renderAreaCore.onStartRender().addEventListener((SbEventListener)new SbEventListener<SiRenderArea.RenderEventArg>(){

            public void onEvent(SiRenderArea.RenderEventArg renderEventArg) {
                RenderAreaInteractive.this.display();
            }
        });
    }

    @Override
    public IRenderAreaInteractive.ClippingPlanesAdjustMode getClippingPlanesAdjustMode() {
        return this.m_clippingMode;
    }

    @Override
    public void setClippingPlanesAdjustMode(IRenderAreaInteractive.ClippingPlanesAdjustMode clippingPlanesAdjustMode) {
        if (this.m_clippingMode != clippingPlanesAdjustMode) {
            this.m_clippingMode = clippingPlanesAdjustMode;
            this.render();
        }
    }

    @Override
    public SceneInteractor getRootSceneGraph() {
        return this.m_rootSceneGraph;
    }

    @Override
    public void viewAll(SbViewportRegion sbViewportRegion) {
        this.m_rootSceneGraph.viewAll(sbViewportRegion);
    }

    @Override
    public void viewAxis(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        this.m_rootSceneGraph.viewAxis(sbVec3f, sbVec3f2);
    }

    @Override
    public void saveCamera() {
        this.m_rootSceneGraph.getCameraInteractor().pushCamera();
    }

    @Override
    public void restoreCamera() {
        this.m_rootSceneGraph.getCameraInteractor().popCamera();
    }

    @Override
    public void setCameraType(SceneInteractor.CameraMode cameraMode) {
        this.m_rootSceneGraph.setCameraMode(cameraMode);
    }

    @Override
    public void activateStereo(boolean bl) {
        if (bl && !this.isStereoSupported()) {
            throw new UnsupportedOperationException("Cannot activate stereo: current camera is not a SoStereoCamera!");
        }
        super.activateStereo(bl);
    }

    @Override
    public boolean isStereoSupported() {
        SoCamera soCamera = this.m_rootSceneGraph.getCamera();
        return soCamera instanceof SoStereoCamera;
    }

    @Override
    public void setStereoCameraOffset(float f) {
        SoCamera soCamera = this.m_rootSceneGraph.getCamera();
        try {
            SoStereoCamera soStereoCamera = (SoStereoCamera)soCamera;
            soStereoCamera.offset.setValue(f);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Current camera is not a SoStereoCamera!");
        }
    }

    @Override
    public void setStereoCameraBalance(float f) {
        SoCamera soCamera = this.m_rootSceneGraph.getCamera();
        try {
            SoStereoCamera soStereoCamera = (SoStereoCamera)soCamera;
            soStereoCamera.balance.setValue(f);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Current camera is not a SoStereoCamera!");
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoMouseButtonEvent soMouseButtonEvent = AWTEventToSoEvent.getMousePressEvent(mouseEvent, (Component)((Object)this));
            this.m_renderAreaCore.processEvent((SoEvent)soMouseButtonEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.m_renderAreaCore != null) {
            SoMouseWheelEvent soMouseWheelEvent = AWTEventToSoEvent.getMouseWheelEvent(mouseWheelEvent, (Component)((Object)this));
            this.m_renderAreaCore.processEvent((SoEvent)soMouseWheelEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoLocation2Event soLocation2Event = AWTEventToSoEvent.getMouseMoveEvent(mouseEvent, (Component)((Object)this));
            this.m_renderAreaCore.processEvent((SoEvent)soLocation2Event);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoLocation2Event soLocation2Event = AWTEventToSoEvent.getMouseMoveEvent(mouseEvent, (Component)((Object)this));
            this.m_renderAreaCore.processEvent((SoEvent)soLocation2Event);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.m_renderAreaCore != null) {
            SoMouseButtonEvent soMouseButtonEvent = AWTEventToSoEvent.getMouseDoubleClickEvent(mouseEvent, (Component)((Object)this));
            this.m_renderAreaCore.processEvent((SoEvent)soMouseButtonEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoMouseButtonEvent soMouseButtonEvent = AWTEventToSoEvent.getMouseReleaseEvent(mouseEvent, (Component)((Object)this));
            this.m_renderAreaCore.processEvent((SoEvent)soMouseButtonEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoLocation2Event soLocation2Event = AWTEventToSoEvent.getMouseEnterEvent(mouseEvent, (Component)((Object)this));
            this.m_renderAreaCore.processEvent((SoEvent)soLocation2Event);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoLocation2Event soLocation2Event = AWTEventToSoEvent.getMouseLeaveEvent(mouseEvent, (Component)((Object)this));
            this.m_renderAreaCore.processEvent((SoEvent)soLocation2Event);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.m_renderAreaCore != null) {
            SoKeyboardEvent soKeyboardEvent = AWTEventToSoEvent.getKeyPressEvent(keyEvent, (Component)((Object)this));
            this.m_renderAreaCore.processEvent((SoEvent)soKeyboardEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.m_renderAreaCore != null) {
            SoKeyboardEvent soKeyboardEvent = AWTEventToSoEvent.getKeyReleaseEvent(keyEvent, (Component)((Object)this));
            this.m_renderAreaCore.processEvent((SoEvent)soKeyboardEvent);
        }
    }
}

