/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.newt.renderareas;

import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MouseEvent;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.viewercomponents.SoEventBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;

public class NewtEventToSoEvent {
    private static Hashtable<Short, SoKeyboardEvent.Keys> newt2OivKey = null;
    private static SoEventBuilder s_ivEvent = new SoEventBuilder();

    private static SoKeyboardEvent.Keys getKeySym(short s) {
        Object[] objectArray;
        if (newt2OivKey == null) {
            newt2OivKey = new Hashtable();
            objectArray = new Object[]{(short)0, SoKeyboardEvent.Keys.ANY, (short)15, SoKeyboardEvent.Keys.LEFT_SHIFT, (short)17, SoKeyboardEvent.Keys.LEFT_CONTROL, (short)18, SoKeyboardEvent.Keys.LEFT_ALT, (short)48, SoKeyboardEvent.Keys.NUMBER_0, (short)49, SoKeyboardEvent.Keys.NUMBER_1, (short)50, SoKeyboardEvent.Keys.NUMBER_2, (short)51, SoKeyboardEvent.Keys.NUMBER_3, (short)52, SoKeyboardEvent.Keys.NUMBER_4, (short)53, SoKeyboardEvent.Keys.NUMBER_5, (short)54, SoKeyboardEvent.Keys.NUMBER_6, (short)55, SoKeyboardEvent.Keys.NUMBER_7, (short)56, SoKeyboardEvent.Keys.NUMBER_8, (short)57, SoKeyboardEvent.Keys.NUMBER_9, (short)65, SoKeyboardEvent.Keys.A, (short)66, SoKeyboardEvent.Keys.B, (short)67, SoKeyboardEvent.Keys.C, (short)68, SoKeyboardEvent.Keys.D, (short)69, SoKeyboardEvent.Keys.E, (short)70, SoKeyboardEvent.Keys.F, (short)71, SoKeyboardEvent.Keys.G, (short)72, SoKeyboardEvent.Keys.H, (short)73, SoKeyboardEvent.Keys.I, (short)74, SoKeyboardEvent.Keys.J, (short)75, SoKeyboardEvent.Keys.K, (short)76, SoKeyboardEvent.Keys.L, (short)77, SoKeyboardEvent.Keys.M, (short)78, SoKeyboardEvent.Keys.N, (short)79, SoKeyboardEvent.Keys.O, (short)80, SoKeyboardEvent.Keys.P, (short)81, SoKeyboardEvent.Keys.Q, (short)82, SoKeyboardEvent.Keys.R, (short)83, SoKeyboardEvent.Keys.S, (short)84, SoKeyboardEvent.Keys.T, (short)85, SoKeyboardEvent.Keys.U, (short)86, SoKeyboardEvent.Keys.V, (short)87, SoKeyboardEvent.Keys.W, (short)88, SoKeyboardEvent.Keys.X, (short)89, SoKeyboardEvent.Keys.Y, (short)90, SoKeyboardEvent.Keys.Z, (short)2, SoKeyboardEvent.Keys.HOME, (short)149, SoKeyboardEvent.Keys.LEFT_ARROW, (short)150, SoKeyboardEvent.Keys.UP_ARROW, (short)151, SoKeyboardEvent.Keys.RIGHT_ARROW, (short)152, SoKeyboardEvent.Keys.DOWN_ARROW, (short)16, SoKeyboardEvent.Keys.PAGE_UP, (short)11, SoKeyboardEvent.Keys.PAGE_DOWN, (short)155, SoKeyboardEvent.Keys.LEFT_META, (short)3, SoKeyboardEvent.Keys.END, (short)128, SoKeyboardEvent.Keys.PAD_0, (short)129, SoKeyboardEvent.Keys.PAD_1, (short)130, SoKeyboardEvent.Keys.PAD_2, (short)131, SoKeyboardEvent.Keys.PAD_3, (short)132, SoKeyboardEvent.Keys.PAD_4, (short)133, SoKeyboardEvent.Keys.PAD_5, (short)134, SoKeyboardEvent.Keys.PAD_6, (short)135, SoKeyboardEvent.Keys.PAD_7, (short)136, SoKeyboardEvent.Keys.PAD_8, (short)137, SoKeyboardEvent.Keys.PAD_9, (short)139, SoKeyboardEvent.Keys.PAD_ADD, (short)140, SoKeyboardEvent.Keys.PAD_SUBTRACT, (short)141, SoKeyboardEvent.Keys.PAD_MULTIPLY, (short)142, SoKeyboardEvent.Keys.PAD_DIVIDE, (short)97, SoKeyboardEvent.Keys.F1, (short)98, SoKeyboardEvent.Keys.F2, (short)99, SoKeyboardEvent.Keys.F3, (short)100, SoKeyboardEvent.Keys.F4, (short)101, SoKeyboardEvent.Keys.F5, (short)102, SoKeyboardEvent.Keys.F6, (short)103, SoKeyboardEvent.Keys.F7, (short)104, SoKeyboardEvent.Keys.F8, (short)105, SoKeyboardEvent.Keys.F9, (short)106, SoKeyboardEvent.Keys.F10, (short)107, SoKeyboardEvent.Keys.F11, (short)108, SoKeyboardEvent.Keys.F12, (short)8, SoKeyboardEvent.Keys.BACKSPACE, (short)9, SoKeyboardEvent.Keys.TAB, (short)13, SoKeyboardEvent.Keys.ENTER, (short)22, SoKeyboardEvent.Keys.PAUSE, (short)23, SoKeyboardEvent.Keys.SCROLL_LOCK, (short)27, SoKeyboardEvent.Keys.ESCAPE, (short)147, SoKeyboardEvent.Keys.KEY_DELETE, (short)5, SoKeyboardEvent.Keys.PRINT, (short)26, SoKeyboardEvent.Keys.INSERT, (short)148, SoKeyboardEvent.Keys.NUM_LOCK, (short)20, SoKeyboardEvent.Keys.CAPS_LOCK, (short)32, SoKeyboardEvent.Keys.SPACE, (short)39, SoKeyboardEvent.Keys.APOSTROPHE, (short)44, SoKeyboardEvent.Keys.COMMA, (short)46, SoKeyboardEvent.Keys.PERIOD, (short)47, SoKeyboardEvent.Keys.SLASH, (short)59, SoKeyboardEvent.Keys.SEMICOLON, (short)61, SoKeyboardEvent.Keys.EQUAL, (short)91, SoKeyboardEvent.Keys.BRACKETLEFT, (short)92, SoKeyboardEvent.Keys.BACKSLASH, (short)93, SoKeyboardEvent.Keys.BRACKETRIGHT, (short)96, SoKeyboardEvent.Keys.GRAVE};
            for (int i = 0; i < objectArray.length; i += 2) {
                newt2OivKey.put((Short)objectArray[i], (SoKeyboardEvent.Keys)objectArray[i + 1]);
            }
            if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                newt2OivKey.put((short)17, SoKeyboardEvent.Keys.LEFT_META);
                newt2OivKey.put((short)155, SoKeyboardEvent.Keys.LEFT_CONTROL);
            }
        }
        if ((objectArray = newt2OivKey.get(s)) == null) {
            return SoKeyboardEvent.Keys.ANY;
        }
        return objectArray;
    }

    private static boolean isControlDown(InputEvent inputEvent) {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return inputEvent.isMetaDown();
        }
        return inputEvent.isControlDown();
    }

    public static SoMouseButtonEvent getMousePressEvent(MouseEvent mouseEvent, Component component) {
        SoMouseButtonEvent.Buttons buttons = NewtEventToSoEvent.getButtonId(mouseEvent);
        int n = component.getSize().height - 1 - mouseEvent.getY();
        return s_ivEvent.getMousePressEvent(mouseEvent.getX(), n, buttons, mouseEvent.isAltDown(), NewtEventToSoEvent.isControlDown((InputEvent)mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoMouseButtonEvent getMouseReleaseEvent(MouseEvent mouseEvent, Component component) {
        SoMouseButtonEvent.Buttons buttons = NewtEventToSoEvent.getButtonId(mouseEvent);
        int n = component.getSize().height - 1 - mouseEvent.getY();
        return s_ivEvent.getMouseReleaseEvent(mouseEvent.getX(), n, buttons, mouseEvent.isAltDown(), NewtEventToSoEvent.isControlDown((InputEvent)mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoMouseButtonEvent getMouseDoubleClickEvent(MouseEvent mouseEvent, Component component) {
        SoMouseButtonEvent.Buttons buttons = NewtEventToSoEvent.getButtonId(mouseEvent);
        int n = component.getSize().height - 1 - mouseEvent.getY();
        return s_ivEvent.getMouseDoubleClickEvent(mouseEvent.getX(), n, buttons, mouseEvent.isAltDown(), NewtEventToSoEvent.isControlDown((InputEvent)mouseEvent), mouseEvent.isShiftDown());
    }

    private static SoMouseButtonEvent.Buttons getButtonId(MouseEvent mouseEvent) {
        SoMouseButtonEvent.Buttons buttons;
        short s = mouseEvent.getButton();
        switch (s) {
            case 1: {
                buttons = SoMouseButtonEvent.Buttons.BUTTON1;
                break;
            }
            case 2: {
                buttons = SoMouseButtonEvent.Buttons.BUTTON2;
                break;
            }
            case 3: {
                buttons = SoMouseButtonEvent.Buttons.BUTTON3;
                break;
            }
            default: {
                buttons = SoMouseButtonEvent.Buttons.ANY;
            }
        }
        return buttons;
    }

    public static SoMouseWheelEvent getMouseWheelEvent(MouseEvent mouseEvent, Component component) {
        int n = mouseEvent.isShiftDown() ? (int)mouseEvent.getRotation()[0] : (int)mouseEvent.getRotation()[1];
        int n2 = n * SoPreferences.getInteger((String)"OIV_WHEEL_DELTA", (int)120);
        return s_ivEvent.getMouseWheelEvent(n2, mouseEvent.isAltDown(), NewtEventToSoEvent.isControlDown((InputEvent)mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoLocation2Event getMouseMoveEvent(MouseEvent mouseEvent, Component component) {
        Dimension dimension = component.getSize();
        int n = dimension.height - 1 - mouseEvent.getY();
        return s_ivEvent.getMouseMoveEvent(mouseEvent.getX(), n, mouseEvent.isAltDown(), NewtEventToSoEvent.isControlDown((InputEvent)mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoLocation2Event getMouseEnterEvent(MouseEvent mouseEvent, Component component) {
        Dimension dimension = component.getSize();
        int n = dimension.height - 1 - mouseEvent.getY();
        return s_ivEvent.getMouseEnterEvent(mouseEvent.getX(), n, mouseEvent.isAltDown(), NewtEventToSoEvent.isControlDown((InputEvent)mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoLocation2Event getMouseLeaveEvent(MouseEvent mouseEvent, Component component) {
        Dimension dimension = component.getSize();
        int n = dimension.height - 1 - mouseEvent.getY();
        return s_ivEvent.getMouseLeaveEvent(mouseEvent.getX(), n, mouseEvent.isAltDown(), NewtEventToSoEvent.isControlDown((InputEvent)mouseEvent), mouseEvent.isShiftDown());
    }

    public static SoKeyboardEvent getKeyPressEvent(KeyEvent keyEvent, Component component) {
        SoKeyboardEvent.Keys keys = NewtEventToSoEvent.getKeySym(keyEvent.getKeySymbol());
        return s_ivEvent.getKeyPressEvent(keys, keyEvent.isAltDown(), NewtEventToSoEvent.isControlDown((InputEvent)keyEvent), keyEvent.isShiftDown());
    }

    public static SoKeyboardEvent getKeyReleaseEvent(KeyEvent keyEvent, Component component) {
        SoKeyboardEvent.Keys keys = NewtEventToSoEvent.getKeySym(keyEvent.getKeySymbol());
        return s_ivEvent.getKeyReleaseEvent(keys, keyEvent.isAltDown(), NewtEventToSoEvent.isControlDown((InputEvent)keyEvent), keyEvent.isShiftDown());
    }
}

