/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.newt.renderareas;

import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.DefaultGLCapabilitiesChooser;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.devices.SoGLContext;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.sensors.SoSystemTimer;
import com.openinventor.inventor.viewercomponents.SoRawStereoParameters;
import com.openinventor.inventor.viewercomponents.SoRenderAreaCore;
import com.openinventor.inventor.viewercomponents.SoStereoParameters;
import com.openinventor.inventor.viewercomponents.awt.IRenderArea;
import com.openinventor.inventor.viewercomponents.awt.Timer;
import java.awt.Canvas;
import java.util.List;
import javax.swing.SwingUtilities;

public class RenderArea
extends NewtCanvasAWT
implements GLEventListener,
IRenderArea {
    protected SoRenderAreaCore m_renderAreaCore = null;
    protected SoNode m_sceneGraph = null;
    protected SoGLRenderAction.TransparencyTypes m_transparencyType;
    private SoGLRenderAction m_glRenderAction;
    protected GLWindow m_glWindow;

    public RenderArea() {
        this(false);
    }

    public RenderArea(boolean bl) {
        SoDB.setSystemTimer((SoSystemTimer)new Timer());
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setHardwareAccelerated(true);
        gLCapabilities.setStereo(bl);
        gLCapabilities.setDepthBits(24);
        gLCapabilities.setStencilBits(8);
        gLCapabilities.setSampleBuffers(false);
        gLCapabilities.setNumSamples(0);
        gLCapabilities.setAlphaBits(8);
        OptionalStereoGLCapabilitiesChooser optionalStereoGLCapabilitiesChooser = new OptionalStereoGLCapabilitiesChooser();
        this.m_glWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        this.m_glWindow.setCapabilitiesChooser((CapabilitiesChooser)optionalStereoGLCapabilitiesChooser);
        this.m_glWindow.addGLEventListener((GLEventListener)this);
        this.m_transparencyType = SoGLRenderAction.TransparencyTypes.BLEND;
        this.m_glRenderAction = null;
        this.setNEWTChild((Window)this.m_glWindow);
    }

    @Override
    public void setTransparencyType(SoGLRenderAction.TransparencyTypes transparencyTypes) {
        this.m_transparencyType = transparencyTypes;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setTransparencyType(this.m_transparencyType);
        }
    }

    @Override
    public SoGLRenderAction.TransparencyTypes getTransparencyType() {
        return this.m_transparencyType;
    }

    @Override
    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.m_glRenderAction = soGLRenderAction;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.getSceneManager().setGLRenderAction(soGLRenderAction);
        }
    }

    @Override
    public SoGLRenderAction getGLRenderAction() {
        return this.m_glRenderAction;
    }

    @Override
    public Canvas getComponent() {
        return this;
    }

    @Override
    public void activateStereo(boolean bl) {
        if (bl) {
            if (!this.isRawStereoAvailable()) {
                throw new UnsupportedOperationException("Stereo buffers are not enabled");
            }
            SoRawStereoParameters soRawStereoParameters = new SoRawStereoParameters();
            this.m_renderAreaCore.setStereoParameters((SoStereoParameters)soRawStereoParameters);
            this.m_renderAreaCore.activateStereo(true);
        } else {
            this.m_renderAreaCore.activateStereo(false);
        }
    }

    @Override
    public boolean isRawStereoAvailable() {
        return this.m_glWindow.getChosenGLCapabilities().getStereo();
    }

    @Override
    public void setSceneGraph(SoNode soNode) {
        this.m_sceneGraph = soNode;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setSceneGraph(soNode);
        }
    }

    @Override
    public void scheduleRedraw() {
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.getSceneManager().scheduleRedraw();
        }
    }

    protected void render() {
        this.m_renderAreaCore.render();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        SoGLContext soGLContext = SoGLContext.getCurrent((boolean)true);
        this.m_renderAreaCore = new SoRenderAreaCore(soGLContext);
        this.m_renderAreaCore.setSceneGraph(this.m_sceneGraph);
        this.m_renderAreaCore.setTransparencyType(this.m_transparencyType);
        if (this.m_glRenderAction == null) {
            this.m_glRenderAction = this.m_renderAreaCore.getSceneManager().getGLRenderAction();
        } else {
            this.m_renderAreaCore.getSceneManager().setGLRenderAction(this.m_glRenderAction);
        }
        soGLContext.unbind();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.m_renderAreaCore.dispose();
    }

    @Override
    public void dispose() {
        this.destroy();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.render();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RenderArea.this.m_glWindow.display();
                }
            });
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, final int n3, final int n4) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_renderAreaCore.setSize(new SbVec2i32(n3, n4));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RenderArea.this.m_renderAreaCore.setSize(new SbVec2i32(n3, n4));
                }
            });
        }
    }

    class OptionalStereoGLCapabilitiesChooser
    extends DefaultGLCapabilitiesChooser {
        OptionalStereoGLCapabilitiesChooser() {
        }

        public int chooseCapabilities(CapabilitiesImmutable capabilitiesImmutable, List<? extends CapabilitiesImmutable> list, int n) {
            int n2 = -1;
            try {
                n2 = super.chooseCapabilities(capabilitiesImmutable, list, n);
            }
            catch (NativeWindowException nativeWindowException) {
                GLCapabilities gLCapabilities = (GLCapabilities)capabilitiesImmutable.cloneMutable();
                if (gLCapabilities.getStereo()) {
                    System.err.println("Could not enable stereo buffers");
                    gLCapabilities.setStereo(false);
                    n2 = super.chooseCapabilities((CapabilitiesImmutable)gLCapabilities, list, n);
                }
                throw nativeWindowException;
            }
            return n2;
        }
    }
}

