/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.newt.renderareas;

import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.opengl.GLAutoDrawable;
import com.openinventor.inventor.SbEventListener;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoStereoCamera;
import com.openinventor.inventor.viewercomponents.SiRenderArea;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.awt.newt.renderareas.NewtEventToSoEvent;
import com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderArea;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class RenderAreaInteractive
extends RenderArea
implements MouseListener,
KeyListener,
IRenderAreaInteractive {
    protected SceneInteractor m_rootSceneGraph;
    private SoGroup m_appSceneGraph;
    private IRenderAreaInteractive.ClippingPlanesAdjustMode m_clippingMode = IRenderAreaInteractive.ClippingPlanesAdjustMode.AUTO;

    public RenderAreaInteractive() {
        this(false);
    }

    public RenderAreaInteractive(boolean bl) {
        this(true, bl);
    }

    protected RenderAreaInteractive(boolean bl, boolean bl2) {
        super(bl2);
        if (bl) {
            this.m_rootSceneGraph = new SceneInteractor();
            this.buildSceneGraph();
        }
        this.m_glWindow.addMouseListener((MouseListener)this);
        this.m_glWindow.addKeyListener((KeyListener)this);
    }

    protected void buildSceneGraph() {
        this.m_appSceneGraph = new SoGroup();
        this.m_rootSceneGraph.addChild((SoNode)this.m_appSceneGraph);
        super.setSceneGraph((SoNode)this.m_rootSceneGraph);
    }

    @Override
    public void setSceneGraph(SoNode soNode) {
        this.m_appSceneGraph.removeAllChildren();
        if (soNode != null) {
            this.m_appSceneGraph.addChild(soNode);
        }
    }

    @Override
    protected void render() {
        if (this.m_clippingMode == IRenderAreaInteractive.ClippingPlanesAdjustMode.AUTO) {
            this.m_rootSceneGraph.adjustClippingPlanes(this.m_renderAreaCore.getSceneManager().getViewportRegion());
        }
        super.render();
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        super.init(gLAutoDrawable);
        this.m_renderAreaCore.onStartRender().addEventListener((SbEventListener)new SbEventListener<SiRenderArea.RenderEventArg>(){

            public void onEvent(SiRenderArea.RenderEventArg renderEventArg) {
                RenderAreaInteractive.this.m_glWindow.display();
            }
        });
    }

    @Override
    public IRenderAreaInteractive.ClippingPlanesAdjustMode getClippingPlanesAdjustMode() {
        return this.m_clippingMode;
    }

    @Override
    public void setClippingPlanesAdjustMode(IRenderAreaInteractive.ClippingPlanesAdjustMode clippingPlanesAdjustMode) {
        if (this.m_clippingMode != clippingPlanesAdjustMode) {
            this.m_clippingMode = clippingPlanesAdjustMode;
            this.scheduleRedraw();
        }
    }

    @Override
    public SceneInteractor getRootSceneGraph() {
        return this.m_rootSceneGraph;
    }

    @Override
    public void viewAll(SbViewportRegion sbViewportRegion) {
        this.m_rootSceneGraph.viewAll(sbViewportRegion);
    }

    @Override
    public void viewAxis(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        this.m_rootSceneGraph.viewAxis(sbVec3f, sbVec3f2);
    }

    @Override
    public void saveCamera() {
        this.m_rootSceneGraph.getCameraInteractor().pushCamera();
    }

    @Override
    public void restoreCamera() {
        this.m_rootSceneGraph.getCameraInteractor().popCamera();
    }

    @Override
    public void setCameraType(SceneInteractor.CameraMode cameraMode) {
        this.m_rootSceneGraph.setCameraMode(cameraMode);
    }

    @Override
    public void activateStereo(boolean bl) {
        if (bl && !this.isStereoSupported()) {
            throw new UnsupportedOperationException("Cannot activate stereo: current camera is not a SoStereoCamera!");
        }
        super.activateStereo(bl);
    }

    @Override
    public boolean isStereoSupported() {
        SoCamera soCamera = this.m_rootSceneGraph.getCamera();
        return soCamera instanceof SoStereoCamera;
    }

    @Override
    public void setStereoCameraOffset(float f) {
        SoCamera soCamera = this.m_rootSceneGraph.getCamera();
        try {
            SoStereoCamera soStereoCamera = (SoStereoCamera)soCamera;
            soStereoCamera.offset.setValue(f);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Current camera is not a SoStereoCamera!");
        }
    }

    @Override
    public void setStereoCameraBalance(float f) {
        SoCamera soCamera = this.m_rootSceneGraph.getCamera();
        try {
            SoStereoCamera soStereoCamera = (SoStereoCamera)soCamera;
            soStereoCamera.balance.setValue(f);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Current camera is not a SoStereoCamera!");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoMouseButtonEvent soMouseButtonEvent = NewtEventToSoEvent.getMousePressEvent(mouseEvent, (Component)((Object)this));
            this.processEventInEDT((SoEvent)soMouseButtonEvent);
        }
    }

    public void mouseWheelMoved(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoMouseWheelEvent soMouseWheelEvent = NewtEventToSoEvent.getMouseWheelEvent(mouseEvent, (Component)((Object)this));
            this.processEventInEDT((SoEvent)soMouseWheelEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoLocation2Event soLocation2Event = NewtEventToSoEvent.getMouseMoveEvent(mouseEvent, (Component)((Object)this));
            this.processEventInEDT((SoEvent)soLocation2Event);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoLocation2Event soLocation2Event = NewtEventToSoEvent.getMouseMoveEvent(mouseEvent, (Component)((Object)this));
            this.processEventInEDT((SoEvent)soLocation2Event);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.m_renderAreaCore != null) {
            SoMouseButtonEvent soMouseButtonEvent = NewtEventToSoEvent.getMouseDoubleClickEvent(mouseEvent, (Component)((Object)this));
            this.processEventInEDT((SoEvent)soMouseButtonEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoMouseButtonEvent soMouseButtonEvent = NewtEventToSoEvent.getMouseReleaseEvent(mouseEvent, (Component)((Object)this));
            this.processEventInEDT((SoEvent)soMouseButtonEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoLocation2Event soLocation2Event = NewtEventToSoEvent.getMouseEnterEvent(mouseEvent, (Component)((Object)this));
            this.processEventInEDT((SoEvent)soLocation2Event);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            SoLocation2Event soLocation2Event = NewtEventToSoEvent.getMouseLeaveEvent(mouseEvent, (Component)((Object)this));
            this.processEventInEDT((SoEvent)soLocation2Event);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.m_renderAreaCore != null) {
            SoKeyboardEvent soKeyboardEvent = NewtEventToSoEvent.getKeyPressEvent(keyEvent, (Component)((Object)this));
            this.processEventInEDT((SoEvent)soKeyboardEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.m_renderAreaCore != null) {
            SoKeyboardEvent soKeyboardEvent = NewtEventToSoEvent.getKeyReleaseEvent(keyEvent, (Component)((Object)this));
            this.processEventInEDT((SoEvent)soKeyboardEvent);
        }
    }

    private void processEventInEDT(final SoEvent soEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_renderAreaCore.processEvent(soEvent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RenderAreaInteractive.this.m_renderAreaCore.processEvent(soEvent);
                }
            });
        }
    }
}

