/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.awt.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPanel
extends JPanel {
    private int m_precision;
    private boolean m_realValues;
    private JSlider m_slider;
    private JFormattedTextField m_textField;
    private JCheckBox m_sliderBox = new JCheckBox();
    private JLabel m_infoText = null;
    private ArrayList<Listener> m_splList;

    private SliderPanel() {
        this.m_sliderBox.setSelected(true);
        this.m_splList = new ArrayList();
    }

    public SliderPanel(int n, int n2, int n3) {
        this();
        this.m_slider = new JSlider(n, n2, n3);
        this.m_textField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.m_textField.setColumns(3);
        this.m_textField.setValue(new Integer(n3));
        this.m_realValues = false;
        this.m_precision = 0;
        this.addListeners();
        this.add(this.m_sliderBox);
        this.add(this.m_slider);
        this.add(this.m_textField);
    }

    public SliderPanel(float f, float f2, float f3, int n) {
        this();
        this.m_precision = n < 1 ? 1 : n;
        this.m_slider = new JSlider((int)((double)f * Math.pow(10.0, this.m_precision)), (int)((double)f2 * Math.pow(10.0, this.m_precision)), (int)((double)f3 * Math.pow(10.0, this.m_precision)));
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumFractionDigits(this.m_precision);
        this.m_textField = new JFormattedTextField(numberFormat);
        this.m_textField.setColumns(2 + this.m_precision);
        this.m_textField.setValue(new Float(f3));
        this.m_realValues = true;
        this.addListeners();
        this.add(this.m_sliderBox);
        this.add(this.m_slider);
        this.add(this.m_textField);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_slider.setEnabled(bl);
        this.m_textField.setEnabled(bl);
        this.m_sliderBox.setEnabled(bl);
        if (this.m_infoText != null) {
            this.m_infoText.setEnabled(bl);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_slider.isEnabled();
    }

    public void setBoxSelected(boolean bl) {
        this.m_sliderBox.setSelected(bl);
    }

    public void addInfoText(String string) {
        this.m_infoText = new JLabel(string);
        this.add((Component)this.m_infoText, 0);
    }

    public void setInfoTextSize(Dimension dimension) {
        if (this.m_infoText != null) {
            this.m_infoText.setPreferredSize(dimension);
        }
    }

    public void setSliderBackground(Color color) {
        this.m_slider.setBackground(color);
    }

    public Color getSliderBackground() {
        return this.m_slider.getBackground();
    }

    public void setSliderSize(Dimension dimension) {
        this.m_slider.setPreferredSize(dimension);
    }

    public float getRelativeSliderValue() {
        if (this.m_realValues) {
            return (float)(this.m_slider.getValue() - this.m_slider.getMinimum()) * (float)Math.pow(10.0, -this.m_precision);
        }
        return this.m_slider.getValue() - this.m_slider.getMinimum();
    }

    public float getSliderValue() {
        if (this.m_realValues) {
            return (float)this.m_slider.getValue() * (float)Math.pow(10.0, -this.m_precision);
        }
        return this.m_slider.getValue();
    }

    public boolean isSliderBoxSelected() {
        return this.m_sliderBox.isSelected();
    }

    public void setSliderValue(float f) {
        boolean bl;
        boolean bl2 = bl = !this.m_sliderBox.isSelected();
        if (bl) {
            this.m_sliderBox.setSelected(true);
        }
        if (this.m_realValues) {
            this.m_slider.setValue((int)((double)f * Math.pow(10.0, this.m_precision)));
        } else {
            this.m_slider.setValue((int)f);
        }
        if (bl) {
            this.m_sliderBox.setSelected(false);
        }
    }

    public void setSliderMax(float f) {
        if (this.m_realValues) {
            this.m_slider.setMaximum((int)((double)f * Math.pow(10.0, this.m_precision)));
        } else {
            this.m_slider.setMaximum((int)f);
        }
    }

    public void setSliderMin(float f) {
        if (this.m_realValues) {
            this.m_slider.setMinimum((int)((double)f * Math.pow(10.0, this.m_precision)));
        } else {
            this.m_slider.setMinimum((int)f);
        }
    }

    public void setTextFieldColumns(int n) {
        this.m_textField.setColumns(n);
    }

    public int getTextFieldColumns() {
        return this.m_textField.getColumns();
    }

    public void setMinorTickSpacing(double d) {
        if (this.m_realValues) {
            this.m_slider.setMajorTickSpacing((int)(d * Math.pow(10.0, this.m_precision)));
        } else {
            this.m_slider.setMajorTickSpacing((int)d);
        }
        this.m_slider.setSnapToTicks(true);
    }

    public void addSliderPanelListener(Listener listener) {
        this.m_splList.add(listener);
    }

    public void removeSliderPanelListener(Listener listener) {
        this.m_splList.remove(listener);
    }

    public void addSliderMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.m_slider.addMouseMotionListener(mouseMotionListener);
    }

    public void addSliderMouseListener(MouseListener mouseListener) {
        this.m_slider.addMouseListener(mouseListener);
    }

    private void addListeners() {
        this.m_textField.addKeyListener(new FieldKeyListener());
        this.m_slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f;
                if (SliderPanel.this.m_realValues) {
                    f = (float)SliderPanel.this.m_slider.getValue() / (float)Math.pow(10.0, SliderPanel.this.m_precision);
                    SliderPanel.this.m_textField.setValue(new Float(f));
                } else {
                    f = SliderPanel.this.m_slider.getValue();
                    SliderPanel.this.m_textField.setValue(new Integer((int)f));
                }
                if (SliderPanel.this.m_sliderBox.isSelected()) {
                    for (Listener listener : SliderPanel.this.m_splList) {
                        listener.stateChanged(f);
                    }
                }
            }
        });
        this.m_slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                float f = SliderPanel.this.m_realValues ? (float)SliderPanel.this.m_slider.getValue() / (float)Math.pow(10.0, SliderPanel.this.m_precision) : (float)SliderPanel.this.m_slider.getValue();
                for (Listener listener : SliderPanel.this.m_splList) {
                    listener.stateChanged(f);
                }
            }
        });
    }

    class FieldKeyListener
    extends KeyAdapter {
        FieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    SliderPanel.this.m_textField.commitEdit();
                    Object object = SliderPanel.this.m_textField.getValue();
                    int n = SliderPanel.this.m_realValues ? (int)((double)((Number)object).floatValue() * Math.pow(10.0, SliderPanel.this.m_precision)) : ((Number)object).intValue();
                    if (n > SliderPanel.this.m_slider.getMaximum()) {
                        SliderPanel.this.m_slider.setMaximum(n);
                    }
                    if (!SliderPanel.this.m_sliderBox.isSelected()) {
                        SliderPanel.this.m_sliderBox.setSelected(true);
                        SliderPanel.this.m_slider.setValue(n);
                        SliderPanel.this.m_sliderBox.setSelected(false);
                    } else {
                        SliderPanel.this.m_slider.setValue(n);
                    }
                }
                catch (ParseException parseException) {
                    SliderPanel.this.m_textField.setValue(SliderPanel.this.m_textField.getValue());
                }
            }
        }
    }

    public static class Listener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
        }

        public void stateChanged(float f) {
        }
    }
}

