/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.medical.helpers;

import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.actions.SoGetBoundingBoxAction;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.errors.SoError;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.helpers.SbFileHelper;
import com.openinventor.inventor.nodes.SoBaseColor;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoImageBackground;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoMatrixTransform;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTextProperty;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.viewercomponents.SoCameraInteractor;
import com.openinventor.ldm.nodes.SoDataRange;
import com.openinventor.ldm.nodes.SoLDMResourceParameters;
import com.openinventor.ldm.readers.SoLDMReader;
import com.openinventor.ldm.readers.SoVolumeReader;
import com.openinventor.medical.nodes.DicomInfo;
import com.openinventor.medical.nodes.SliceOrientationMarkers;
import com.openinventor.medical.nodes.SliceScaleBar;
import com.openinventor.medical.nodes.TextBox;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.readers.SoVRDicomData;
import com.openinventor.volumeviz.readers.SoVRDicomFileReader;
import com.openinventor.volumeviz.readers.dicom.SiDicomDataSet;
import com.openinventor.volumeviz.readers.dicom.SiDicomElement;
import com.openinventor.volumeviz.readers.dicom.SiDicomValue;
import com.openinventor.volumeviz.readers.dicom.SoDicomTag;
import java.io.File;
import java.io.FileNotFoundException;

public class MedicalHelper {
    public static final String EXAMPLE_LOGO = "$OIVJHOME/source/com/openinventor/medical/data/oiv_logo_white_test.png";
    public static final short WINDOW_HEIGHT = 633;
    public static final short WINDOW_WIDTH = 1024;

    public static SoNode exampleDicomAnnotation(String string) {
        SoSeparator soSeparator = new SoSeparator();
        if (string.length() <= 0) {
            return soSeparator;
        }
        DicomInfo dicomInfo = new DicomInfo();
        dicomInfo.fileName.setValue(string);
        dicomInfo.position.setValue(new SbVec3f(-0.99f, 0.99f, 0.0f));
        dicomInfo.displayDicomInfo("Patient Name : ", (short)16, (short)16);
        dicomInfo.displayDicomInfo("Patient Id : ", (short)16, (short)32);
        dicomInfo.displayDicomInfo("Institution Name : ", (short)8, (short)128);
        dicomInfo.displayDicomInfo("Modality : ", (short)8, (short)96);
        dicomInfo.displayDicomInfo("Patient Pos : ", (short)24, (short)20736);
        dicomInfo.displayDicomInfo("Patient orientation : ", (short)32, (short)32);
        dicomInfo.displayDicomInfo("samples per pixel : ", (short)40, (short)2);
        dicomInfo.displayDicomInfo("Photometric interp : ", (short)40, (short)4);
        dicomInfo.displayDicomInfo("Image Orientation : ", (short)32, (short)55);
        dicomInfo.displayDicomInfo("Image rows (height) : ", (short)40, (short)16);
        dicomInfo.displayDicomInfo("Image columns (width) : ", (short)40, (short)17);
        soSeparator.addChild((SoNode)dicomInfo);
        DicomInfo dicomInfo2 = new DicomInfo();
        dicomInfo2.alignmentH.setValue((Enum)TextBox.AlignmentH.RIGHT);
        dicomInfo2.alignmentV.setValue((Enum)TextBox.AlignmentV.BOTTOM);
        dicomInfo2.fileName.setValue(string);
        dicomInfo2.position.setValue(new SbVec3f(0.99f, -0.99f, 0.0f));
        dicomInfo2.displayDicomInfo("Convolution Kernel : ", (short)24, (short)4624);
        dicomInfo2.displayDicomInfo("Thickness : ", (short)24, (short)80);
        dicomInfo2.displayDicomInfo("kVp : ", (short)24, (short)96);
        soSeparator.addChild((SoNode)dicomInfo2);
        DicomInfo dicomInfo3 = new DicomInfo();
        dicomInfo3.alignmentH.setValue((Enum)TextBox.AlignmentH.RIGHT);
        dicomInfo3.fileName.setValue(string);
        dicomInfo3.position.setValue(new SbVec3f(0.99f, 0.99f, 0.0f));
        dicomInfo3.displayDicomInfo("Patient Birthday : ", (short)16, (short)48);
        dicomInfo3.displayDicomInfo("Aquisition date : ", (short)8, (short)34);
        dicomInfo3.displayDicomInfo("Patient's Age : ", (short)16, (short)4112);
        dicomInfo3.displayDicomInfo("Sex : ", (short)16, (short)64);
        soSeparator.addChild((SoNode)dicomInfo3);
        return soSeparator;
    }

    public static void dollyZoom(float f, SoCameraInteractor soCameraInteractor) {
        if (soCameraInteractor != null && f != 0.0f) {
            soCameraInteractor.dolly(1.0f / f);
        }
    }

    public static SoNode getExampleLogoNode() throws FileNotFoundException {
        File file = new File(SbFileHelper.expandString((String)EXAMPLE_LOGO));
        if (!file.exists()) {
            throw new FileNotFoundException("Resource $OIVJHOME/source/com/openinventor/medical/data/oiv_logo_white_test.png not found");
        }
        SoImageBackground soImageBackground = new SoImageBackground();
        soImageBackground.style.setValue((Enum)SoImageBackground.Styles.LOWER_LEFT);
        soImageBackground.filename.setValue(EXAMPLE_LOGO);
        return soImageBackground;
    }

    public static boolean dicomAdjustDataRange(SoDataRange soDataRange, SoVolumeData soVolumeData) {
        if (soDataRange == null) {
            return false;
        }
        SbVec2f sbVec2f = new SbVec2f(0.0f, 0.0f);
        boolean bl = MedicalHelper.dicomGetWindowCenterWidth(soVolumeData, sbVec2f);
        soDataRange.min.setValue((double)(sbVec2f.getValueAt(0) - 0.5f * sbVec2f.getValueAt(1)));
        soDataRange.max.setValue((double)(sbVec2f.getValueAt(0) + 0.5f * sbVec2f.getValueAt(1)));
        return bl;
    }

    public static boolean dicomGetWindowCenterWidth(SoVolumeData soVolumeData, SbVec2f sbVec2f) {
        boolean bl = false;
        float f = 0.0f;
        float f2 = 0.0f;
        if (soVolumeData != null) {
            SoVRDicomFileReader soVRDicomFileReader;
            SoVRDicomData soVRDicomData;
            String string;
            SoVolumeReader soVolumeReader = soVolumeData.getReader();
            if (soVolumeReader != null && soVolumeReader instanceof SoVRDicomFileReader && (string = (soVRDicomData = (soVRDicomFileReader = (SoVRDicomFileReader)soVolumeReader).getDicomData()).getDicomInfo((short)40, (short)4176)).length() > 0) {
                f = Float.parseFloat(string);
                string = soVRDicomData.getDicomInfo((short)40, (short)4177);
                if (string.length() > 0) {
                    f2 = Float.parseFloat(string);
                    bl = true;
                }
            }
            if (!bl) {
                long[] lArray = soVolumeData.getMinMax();
                double d = lArray[0];
                double d2 = lArray[1];
                f2 = (float)(d2 - d);
                f = (float)(d + (double)(0.5f * f2));
            }
        }
        sbVec2f.setValue(f, f2);
        return bl;
    }

    public static SoSeparator buildSliceOrientationMarkers(SoOrthoSlice soOrthoSlice) {
        SoSeparator soSeparator = new SoSeparator();
        SoMaterial soMaterial = new SoMaterial();
        soMaterial.diffuseColor.setValue(1.0f, 1.0f, 0.25f);
        soSeparator.addChild((SoNode)soMaterial);
        SoTextProperty soTextProperty = new SoTextProperty();
        soTextProperty.margin.setValue(0.1f);
        soTextProperty.style.setValue((Enum)SoTextProperty.Styles.BACK_FRAME);
        soTextProperty.styleColors.set1Value(3, new SbColorRGBA(0.0f, 0.1f, 0.1f, 0.25f));
        soSeparator.addChild((SoNode)soTextProperty);
        SliceOrientationMarkers sliceOrientationMarkers = new SliceOrientationMarkers();
        if (soOrthoSlice != null) {
            sliceOrientationMarkers.axis.connectFrom((SoField)soOrthoSlice.axis);
        }
        soSeparator.addChild((SoNode)sliceOrientationMarkers);
        return soSeparator;
    }

    public static SoSeparator buildSliceScaleBars(SoCamera soCamera) {
        SoSeparator soSeparator = new SoSeparator();
        SoMaterial soMaterial = new SoMaterial();
        soMaterial.diffuseColor.setValue(1.0f, 0.25f, 0.25f);
        soSeparator.addChild((SoNode)soMaterial);
        SoDrawStyle soDrawStyle = new SoDrawStyle();
        soDrawStyle.lineWidth.setValue(2.0f);
        soSeparator.addChild((SoNode)soDrawStyle);
        SliceScaleBar sliceScaleBar = new SliceScaleBar();
        sliceScaleBar.position.setValue(0.0f, -0.99f);
        sliceScaleBar.length.setValue(100.0f);
        if (soCamera != null) {
            sliceScaleBar.trackedCamera.setValue((SoNode)soCamera);
        }
        sliceScaleBar.label.setValue("10cm");
        soSeparator.addChild((SoNode)sliceScaleBar);
        SliceScaleBar sliceScaleBar2 = new SliceScaleBar();
        sliceScaleBar2.position.setValue(-0.99f, 0.0f);
        sliceScaleBar2.length.setValue(100.0f);
        sliceScaleBar2.orientation.setValue((Enum)SliceScaleBar.Orientation.VERTICAL);
        if (soCamera != null) {
            sliceScaleBar2.trackedCamera.setValue((SoNode)soCamera);
        }
        sliceScaleBar2.label.setValue("10cm");
        soSeparator.addChild((SoNode)sliceScaleBar2);
        return soSeparator;
    }

    public static SoSeparator buildSliceAnnotation(SoCamera soCamera, SoOrthoSlice soOrthoSlice, String string) {
        SoSeparator soSeparator = new SoSeparator();
        if (soCamera == null || soOrthoSlice == null) {
            return soSeparator;
        }
        soSeparator.addChild((SoNode)MedicalHelper.buildSliceOrientationMarkers(soOrthoSlice));
        soSeparator.addChild((SoNode)MedicalHelper.buildSliceScaleBars(soCamera));
        if (!string.isEmpty()) {
            SoMaterial soMaterial = new SoMaterial();
            soMaterial.diffuseColor.setValue(0.8f, 0.8f, 0.5f);
            soSeparator.addChild((SoNode)soMaterial);
            DicomInfo dicomInfo = new DicomInfo();
            dicomInfo.fileName.setValue(string);
            dicomInfo.position.setValue(-0.99f, 0.99f, 0.0f);
            dicomInfo.alignmentV.setValue((Enum)TextBox.AlignmentV.TOP);
            dicomInfo.displayDicomInfo("", (short)16, (short)16);
            dicomInfo.displayDicomInfo("", (short)16, (short)48);
            dicomInfo.displayDicomInfo("", (short)8, (short)4144);
            dicomInfo.displayDicomInfo("", (short)8, (short)4158);
            soSeparator.addChild((SoNode)dicomInfo);
            DicomInfo dicomInfo2 = new DicomInfo();
            dicomInfo2.fileName.setValue(string);
            dicomInfo2.position.setValue(0.99f, 0.99f, 0.0f);
            dicomInfo2.alignmentH.setValue((Enum)TextBox.AlignmentH.RIGHT);
            dicomInfo2.alignmentV.setValue((Enum)TextBox.AlignmentV.TOP);
            dicomInfo2.textAlignH.setValue((Enum)TextBox.AlignmentH.RIGHT);
            dicomInfo2.displayDicomInfo("", (short)8, (short)128);
            dicomInfo2.displayDicomInfo("", (short)8, (short)144);
            dicomInfo2.displayDicomInfo("", (short)8, (short)4240);
            soSeparator.addChild((SoNode)dicomInfo2);
            DicomInfo dicomInfo3 = new DicomInfo();
            dicomInfo3.fileName.setValue(string);
            dicomInfo3.position.setValue(0.99f, -0.99f, 0.0f);
            dicomInfo3.alignmentH.setValue((Enum)TextBox.AlignmentH.RIGHT);
            dicomInfo3.alignmentV.setValue((Enum)TextBox.AlignmentV.BOTTOM);
            dicomInfo3.textAlignH.setValue((Enum)TextBox.AlignmentH.RIGHT);
            dicomInfo3.displayDicomInfo("", (short)8, (short)96);
            dicomInfo3.displayDicomInfo("mA: ", (short)24, (short)4433);
            dicomInfo3.displayDicomInfo("kV: ", (short)24, (short)96);
            dicomInfo3.displayDicomInfo("", (short)8, (short)34);
            soSeparator.addChild((SoNode)dicomInfo3);
            TextBox textBox = new TextBox();
            textBox.position.setValue(-0.99f, -0.94f, 0.0f);
            textBox.alignmentV.setValue((Enum)TextBox.AlignmentV.BOTTOM);
            textBox.addLine("Image: " + soOrthoSlice.sliceNumber.getValue());
            soSeparator.addChild((SoNode)textBox);
        }
        return soSeparator;
    }

    public static boolean dicomAdjustVolume(SoVolumeData soVolumeData, boolean bl) {
        int n;
        if (soVolumeData == null) {
            return false;
        }
        SoVolumeReader soVolumeReader = soVolumeData.getReader();
        if (soVolumeReader != null && !(soVolumeReader instanceof SoLDMReader)) {
            SbVec3i32 sbVec3i32 = soVolumeData.data.getSize();
            int n2 = Math.max(sbVec3i32.getX(), Math.max(sbVec3i32.getY(), sbVec3i32.getZ()));
            if (n2 == 0) {
                return false;
            }
            n2 = Math.min(n2, 512);
            n2 = MedicalHelper.nextPowerOf2(n2);
            int n3 = Math.min(n2, sbVec3i32.getZ());
            n3 = MedicalHelper.nextPowerOf2(n3);
            SoLDMResourceParameters soLDMResourceParameters = soVolumeData.ldmResourceParameters.getValue();
            soLDMResourceParameters.tileDimension.setValue(n2, n2, n3);
        }
        if ((n = soVolumeData.getDatumSize()) == 2) {
            soVolumeData.texturePrecision.setValue((short)16);
        }
        if (soVolumeReader != null && soVolumeReader instanceof SoVRDicomFileReader) {
            SoVRDicomFileReader soVRDicomFileReader = (SoVRDicomFileReader)soVolumeReader;
            SoVRDicomData soVRDicomData = soVRDicomFileReader.getDicomData();
            float f = soVRDicomData.getXPixelSize();
            float f2 = soVRDicomData.getYPixelSize();
            SbVec3i32 sbVec3i32 = soVolumeData.data.getSize();
            SbVec3f sbVec3f = soVolumeData.extent.getValue().getSize();
            float f3 = sbVec3i32.getZ() <= 1 ? sbVec3f.getZ() : sbVec3f.getZ() / (float)(sbVec3i32.getZ() - 1);
            SbVec3f sbVec3f2 = new SbVec3f(f * 0.5f, f2 * 0.5f, f3 * 0.5f);
            if (bl) {
                SbVec3f sbVec3f3 = new SbVec3f((float)sbVec3i32.getX() * f, (float)sbVec3i32.getY() * f2, (float)sbVec3i32.getZ() * f3);
                SbVec3f sbVec3f4 = MedicalHelper.dicomGetImagePosition(soVolumeData);
                SbVec3f sbVec3f5 = sbVec3f4.minus(sbVec3f2);
                SbVec3f sbVec3f6 = sbVec3f5.plus(sbVec3f3);
                SbBox3f sbBox3f = new SbBox3f(sbVec3f5, sbVec3f6);
                soVolumeData.extent.setValue(sbBox3f);
                if (!soVRDicomData.getOrientation().equals((Object)SbMatrix.identity())) {
                    SoError.post((String)"Given DICOM volume doesn't seems to be axis aligned. You should use dicomAdjustVolume(SoVolumeData, SoMatrixTransform) method instead.");
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean dicomAdjustVolume(SoVolumeData soVolumeData, SoMatrixTransform soMatrixTransform) {
        if (soMatrixTransform == null) {
            SoError.post((String)"null SoMatrixTransform specified.");
            return false;
        }
        if (soVolumeData == null) {
            SoError.post((String)"null volume specified.");
            soMatrixTransform.matrix.setValue(SbMatrix.identity());
            return false;
        }
        if (!MedicalHelper.dicomAdjustVolume(soVolumeData, false)) {
            SoError.post((String)"Error while adjusting volume extent.");
            soMatrixTransform.matrix.setValue(SbMatrix.identity());
            return false;
        }
        if (!(soVolumeData.getReader() instanceof SoVRDicomFileReader)) {
            SoError.post((String)"Cannot retrive DICOM reader.");
            soMatrixTransform.matrix.setValue(SbMatrix.identity());
            return false;
        }
        SbBox3f sbBox3f = soVolumeData.extent.getValue();
        SbVec3i32 sbVec3i32 = soVolumeData.data.getSize();
        if (sbBox3f.getSize().getX() == 0.0f || sbBox3f.getSize().getY() == 0.0f) {
            SoError.post((String)"Volume extent is empty. Cannot define spaces.");
            soMatrixTransform.matrix.setValue(SbMatrix.identity());
            return false;
        }
        if (sbVec3i32.getX() == 0 || sbVec3i32.getY() == 0 || sbVec3i32.getZ() == 0) {
            SoError.post((String)"Image has no dimension. Cannot define spaces.");
            soMatrixTransform.matrix.setValue(SbMatrix.identity());
            return false;
        }
        SbVec3f sbVec3f = new SbVec3f(0.5f * sbBox3f.getSize().getX() / (float)sbVec3i32.getX(), 0.5f * sbBox3f.getSize().getX() / (float)sbVec3i32.getY(), 0.5f * sbBox3f.getSize().getY() / (float)sbVec3i32.getZ());
        SbVec3f sbVec3f2 = sbBox3f.getSize();
        soVolumeData.extent.setValue(-sbVec3f.getX(), -sbVec3f.getY(), -sbVec3f.getZ(), -sbVec3f.getX() + sbVec3f2.getX(), -sbVec3f.getY() + sbVec3f2.getY(), -sbVec3f.getZ() + sbVec3f2.getZ());
        SoVRDicomFileReader soVRDicomFileReader = (SoVRDicomFileReader)soVolumeData.getReader();
        SbVec3f sbVec3f3 = soVRDicomFileReader.getDicomData().getImagePosition();
        SbMatrix sbMatrix = soVRDicomFileReader.getDicomData().getOrientation();
        sbMatrix.setElement(0, 3, sbVec3f3.getX());
        sbMatrix.setElement(1, 3, sbVec3f3.getY());
        sbMatrix.setElement(2, 3, sbVec3f3.getZ());
        soMatrixTransform.matrix.setValue(sbMatrix);
        return true;
    }

    private static int nextPowerOf2(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    public static SbVec3f dicomGetImagePosition(SoVolumeData soVolumeData) {
        SoDicomTag soDicomTag;
        SoVRDicomFileReader soVRDicomFileReader;
        SoVRDicomData soVRDicomData;
        SiDicomDataSet siDicomDataSet;
        SiDicomElement siDicomElement;
        SiDicomValue siDicomValue;
        SoVolumeReader soVolumeReader;
        SbVec3f sbVec3f = new SbVec3f(0.0f, 0.0f, 0.0f);
        if (soVolumeData != null && (soVolumeReader = soVolumeData.getReader()) != null && soVolumeReader instanceof SoVRDicomFileReader && (siDicomValue = (siDicomElement = (siDicomDataSet = (soVRDicomData = (soVRDicomFileReader = (SoVRDicomFileReader)soVolumeReader).getDicomData()).getDicomDataSet()).getElement(soDicomTag = new SoDicomTag(32, 50))).getValue()).getLength() == 3L) {
            sbVec3f = new SbVec3f((float)siDicomValue.getDouble(0L), (float)siDicomValue.getDouble(1L), (float)siDicomValue.getDouble(2L));
        }
        return sbVec3f;
    }

    public static SoSeparator createBoundingBox(SbBox3f sbBox3f, SbColor sbColor) {
        SoSeparator soSeparator = new SoSeparator();
        SoTransform soTransform = new SoTransform();
        soTransform.translation.setValue(sbBox3f.getCenter());
        soTransform.scaleFactor.setValue(sbBox3f.getSize().times(0.5f));
        soSeparator.addChild((SoNode)soTransform);
        SoPickStyle soPickStyle = new SoPickStyle();
        soPickStyle.style.setValue((Enum)SoPickStyle.Styles.UNPICKABLE);
        soSeparator.addChild((SoNode)soPickStyle);
        SoLightModel soLightModel = new SoLightModel();
        soLightModel.model.setValue((Enum)SoLightModel.Models.BASE_COLOR);
        soSeparator.addChild((SoNode)soLightModel);
        SoBaseColor soBaseColor = new SoBaseColor();
        soBaseColor.rgb.setValue(sbColor == null ? new SbColor(1.0f, 0.0f, 0.0f) : sbColor);
        soSeparator.addChild((SoNode)soBaseColor);
        SoDrawStyle soDrawStyle = new SoDrawStyle();
        soDrawStyle.lineWidth.setValue(1.0f);
        soDrawStyle.style.setValue((Enum)SoDrawStyle.Styles.LINES);
        soSeparator.addChild((SoNode)soDrawStyle);
        SoCube soCube = new SoCube();
        soSeparator.addChild((SoNode)soCube);
        return soSeparator;
    }

    public static SbBox3f getBoundingBox(SoNode soNode) {
        SoVolumeData soVolumeData = MedicalHelper.find(soNode, SoVolumeData.class);
        if (soVolumeData != null) {
            return soVolumeData.extent.getValue();
        }
        SbViewportRegion sbViewportRegion = new SbViewportRegion(new SbVec2i32(1, 1));
        SoGetBoundingBoxAction soGetBoundingBoxAction = new SoGetBoundingBoxAction(sbViewportRegion);
        soGetBoundingBoxAction.apply(soNode);
        return soGetBoundingBoxAction.getBoundingBox();
    }

    public static SoSeparator createCube(SbBox3f sbBox3f) {
        SoSeparator soSeparator = new SoSeparator();
        SoTransform soTransform = new SoTransform();
        soTransform.translation.setValue(sbBox3f.getCenter());
        SbVec3f sbVec3f = sbBox3f.getSize();
        sbVec3f.multiply(0.5f);
        soTransform.scaleFactor.setValue(sbVec3f);
        soSeparator.addChild((SoNode)soTransform);
        SoCube soCube = new SoCube();
        soSeparator.addChild((SoNode)soCube);
        return soSeparator;
    }

    public static boolean orientView(Axis axis, SoCamera soCamera, SoVolumeData soVolumeData) {
        return MedicalHelper.orientView(axis, soCamera, soVolumeData, 1.01f);
    }

    public static boolean orientView(Axis axis, SoCamera soCamera, SoVolumeData soVolumeData, float f) {
        SbViewportRegion sbViewportRegion;
        if (soCamera == null) {
            return false;
        }
        SbVec3f sbVec3f = new SbVec3f(1.0f, 1.0f, 1.0f);
        SbBox3f sbBox3f = new SbBox3f(-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f);
        if (soVolumeData != null) {
            sbBox3f = soVolumeData.extent.getValue();
            sbVec3f = sbBox3f.getSize();
        }
        float f2 = 1.0f;
        float f3 = 1.0f;
        SbRotation sbRotation = new SbRotation();
        if (axis == Axis.SAGITTAL) {
            f2 = sbVec3f.getY();
            f3 = sbVec3f.getZ();
            sbRotation = new SbRotation(new SbVec3f(0.0f, 0.0f, 1.0f), 1.5707964f);
            sbViewportRegion = new SbRotation(new SbVec3f(0.0f, 1.0f, 0.0f), 1.5707964f);
            sbRotation.multiply((SbRotation)sbViewportRegion);
        } else if (axis == Axis.CORONAL) {
            f2 = sbVec3f.getX();
            f3 = sbVec3f.getZ();
            sbRotation = new SbRotation(new SbVec3f(1.0f, 0.0f, 0.0f), 1.5707964f);
        } else {
            f2 = sbVec3f.getX();
            f3 = sbVec3f.getY();
            sbRotation = new SbRotation(new SbVec3f(1.0f, 0.0f, 0.0f), (float)Math.PI);
        }
        sbViewportRegion = new SbViewportRegion(500, 500);
        soCamera.orientation.setValue(sbRotation);
        if (soCamera instanceof SoPerspectiveCamera) {
            if (soVolumeData != null) {
                soCamera.viewAll(sbBox3f, sbViewportRegion);
            }
        } else {
            SoOrthographicCamera soOrthographicCamera = (SoOrthographicCamera)soCamera;
            if (soVolumeData != null) {
                soOrthographicCamera.viewAll(sbBox3f, sbViewportRegion);
                f3 = f3 >= f2 ? f3 : f2;
                soOrthographicCamera.height.setValue(f3 * f);
            }
        }
        return true;
    }

    public static <NodeClass extends SoNode> NodeClass find(SoNode soNode, Class<NodeClass> clazz, String string) {
        if (soNode == null) {
            return null;
        }
        SoSearchAction soSearchAction = new SoSearchAction();
        if (string.length() > 0) {
            soSearchAction.setName(string);
        }
        soSearchAction.setSearchingAll(true);
        soSearchAction.setNodeClass(clazz);
        soSearchAction.setInterest(SoSearchAction.Interests.FIRST);
        soSearchAction.apply(soNode);
        SoPath soPath = soSearchAction.getPath();
        if (soPath != null) {
            return (NodeClass)soPath.regular.getTail();
        }
        return null;
    }

    public static <NodeClass extends SoNode> NodeClass find(SoNode soNode, Class<NodeClass> clazz) {
        return MedicalHelper.find(soNode, clazz, "");
    }

    public static SoSeparator readFile(String string) {
        SoInput soInput = new SoInput();
        if (!soInput.openFile(string)) {
            SoError.post((String)("Cannot open file " + string));
            return null;
        }
        SoSeparator soSeparator = SoDB.readAll((SoInput)soInput);
        if (soSeparator == null) {
            SoError.post((String)("Problem reading file " + string));
            return null;
        }
        soInput.closeFile();
        return soSeparator;
    }

    public static enum Axis implements IntegerValuedEnum
    {
        AXIAL(2),
        TRANSVERSE(2),
        CORONAL(1),
        SAGITTAL(0);

        private final int axis;

        public int getValue() {
            return this.axis;
        }

        private Axis(int n2) {
            this.axis = n2;
        }
    }
}

