/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.medical.nodes;

import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFColor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFUInt32;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoFaceSet;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoPolygonOffset;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.volumeviz.elements.SoVolumeDataElement;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;

public class OrthoSliceBorder
extends SoNode {
    public SoSFBool border = new SoSFBool((SoFieldContainer)this, "Border", SoField.FieldTypes.EXPOSED_FIELD, true);
    public SoSFColor borderColor = new SoSFColor((SoFieldContainer)this, "BorderColor", SoField.FieldTypes.EXPOSED_FIELD, new SbColor(0.84f, 0.43f, 0.02f));
    public SoSFEnum<AxisType> axis = new SoSFEnum((SoFieldContainer)this, "Axis", SoField.FieldTypes.EXPOSED_FIELD, AxisType.class, (Enum)AxisType.Z);
    public SoSFUInt32 sliceNumber = new SoSFUInt32((SoFieldContainer)this, "SliceNumber", SoField.FieldTypes.EXPOSED_FIELD, 0);
    private SoSeparator _scene;
    private SoSwitch _switch;
    private SoFaceSet _geometry;
    private SbBox3f _volumeExtent;
    private int _sliceAxis;
    private int _sliceNumber;

    public OrthoSliceBorder() {
        this.buildSceneGraph();
    }

    public void GLRender(SoGLRenderAction soGLRenderAction) {
        boolean bl = this.border.getValue();
        if (bl) {
            this._switch.whichChild.setValue(-3);
        } else {
            this._switch.whichChild.setValue(-1);
        }
        if (!bl) {
            return;
        }
        SoVertexProperty soVertexProperty = (SoVertexProperty)this._geometry.vertexProperty.getValue();
        soVertexProperty.orderedRGBA.set1Value(0, this.borderColor.getValue().getPackedValue());
        SoVolumeData soVolumeData = SoVolumeDataElement.getVolumeData((SoState)soGLRenderAction.getState());
        if (soVolumeData != null) {
            SbBox3f sbBox3f = soVolumeData.extent.getValue();
            int n = this.axis.getValue();
            int n2 = this.sliceNumber.getValue();
            if (sbBox3f != this._volumeExtent || n != this._sliceAxis || n2 != this._sliceNumber) {
                this._sliceAxis = n;
                this._sliceNumber = n2;
                this._volumeExtent = sbBox3f;
                SbVec3i32 sbVec3i32 = soVolumeData.data.getSize();
                SbVec3f sbVec3f = sbBox3f.getMin();
                SbVec3f sbVec3f2 = sbBox3f.getMax();
                soVertexProperty.vertex.setNum(5);
                if (n == 0) {
                    float f = (sbVec3f2.getX() - sbVec3f.getX()) / (float)sbVec3i32.getX();
                    float f2 = sbVec3f.getX() + ((float)n2 + 0.5f) * f;
                    soVertexProperty.vertex.set1Value(0, f2, sbVec3f.getY(), sbVec3f.getZ());
                    soVertexProperty.vertex.set1Value(1, f2, sbVec3f2.getY(), sbVec3f.getZ());
                    soVertexProperty.vertex.set1Value(2, f2, sbVec3f2.getY(), sbVec3f2.getZ());
                    soVertexProperty.vertex.set1Value(3, f2, sbVec3f.getY(), sbVec3f2.getZ());
                    soVertexProperty.vertex.set1Value(4, f2, sbVec3f.getY(), sbVec3f.getZ());
                } else if (n == 1) {
                    float f = (sbVec3f2.getY() - sbVec3f.getY()) / (float)sbVec3i32.getY();
                    float f3 = sbVec3f.getY() + ((float)n2 + 0.5f) * f;
                    soVertexProperty.vertex.set1Value(0, sbVec3f.getX(), f3, sbVec3f.getZ());
                    soVertexProperty.vertex.set1Value(1, sbVec3f2.getX(), f3, sbVec3f.getZ());
                    soVertexProperty.vertex.set1Value(2, sbVec3f2.getX(), f3, sbVec3f2.getZ());
                    soVertexProperty.vertex.set1Value(3, sbVec3f.getX(), f3, sbVec3f2.getZ());
                    soVertexProperty.vertex.set1Value(4, sbVec3f.getX(), f3, sbVec3f.getZ());
                } else {
                    float f = (sbVec3f2.getZ() - sbVec3f.getZ()) / (float)sbVec3i32.getZ();
                    float f4 = sbVec3f.getZ() + ((float)n2 + 0.5f) * f;
                    soVertexProperty.vertex.set1Value(0, sbVec3f.getX(), sbVec3f.getY(), f4);
                    soVertexProperty.vertex.set1Value(1, sbVec3f2.getX(), sbVec3f.getY(), f4);
                    soVertexProperty.vertex.set1Value(2, sbVec3f2.getX(), sbVec3f2.getY(), f4);
                    soVertexProperty.vertex.set1Value(3, sbVec3f.getX(), sbVec3f2.getY(), f4);
                    soVertexProperty.vertex.set1Value(4, sbVec3f.getX(), sbVec3f.getY(), f4);
                }
            }
        } else {
            this._switch.whichChild.setValue(-1);
        }
        soGLRenderAction.forwardTraversal((SoNode)this._scene);
    }

    private void buildSceneGraph() {
        this._sliceAxis = -1;
        this._sliceNumber = -1;
        this._volumeExtent = new SbBox3f();
        this._volumeExtent.makeEmpty();
        this._scene = new SoSeparator();
        this._switch = new SoSwitch();
        if (this.border.getValue()) {
            this._switch.whichChild.setValue(-3);
        } else {
            this._switch.whichChild.setValue(-1);
        }
        this._scene.addChild((SoNode)this._switch);
        SoPolygonOffset soPolygonOffset = new SoPolygonOffset();
        soPolygonOffset.units.setValue(-1.0f);
        soPolygonOffset.factor.setValue(-1.0f);
        this._switch.addChild((SoNode)soPolygonOffset);
        SoLightModel soLightModel = new SoLightModel();
        soLightModel.model.setValue((Enum)SoLightModel.Models.BASE_COLOR);
        this._switch.addChild((SoNode)soLightModel);
        SoPickStyle soPickStyle = new SoPickStyle();
        soPickStyle.style.setValue((Enum)SoPickStyle.Styles.UNPICKABLE);
        this._switch.addChild((SoNode)soPickStyle);
        SoDrawStyle soDrawStyle = new SoDrawStyle();
        soDrawStyle.style.setValue((Enum)SoDrawStyle.Styles.LINES);
        soDrawStyle.lineWidth.setValue(2.0f);
        soDrawStyle.linePattern.setIgnored(true);
        soDrawStyle.linePatternScaleFactor.setIgnored(true);
        this._switch.addChild((SoNode)soDrawStyle);
        SoVertexProperty soVertexProperty = new SoVertexProperty();
        soVertexProperty.orderedRGBA.setValue(this.borderColor.getValue().getPackedValue());
        this._geometry = new SoFaceSet();
        this._geometry.vertexProperty.setValue((SoNode)soVertexProperty);
        this._switch.addChild((SoNode)this._geometry);
    }

    public static enum AxisType implements IntegerValuedEnum
    {
        X(SoOrthoSlice.AxisType.X.getValue()),
        Y(SoOrthoSlice.AxisType.Y.getValue()),
        Z(SoOrthoSlice.AxisType.Z.getValue());

        private final int _axis;

        private AxisType(int n2) {
            this._axis = n2;
        }

        public int getValue() {
            return this._axis;
        }
    }
}

