/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.medical.nodes;

import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewVolume;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.actions.SoGetBoundingBoxAction;
import com.openinventor.inventor.elements.SoViewVolumeElement;
import com.openinventor.inventor.elements.SoViewportRegionElement;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.fields.SoSFNode;
import com.openinventor.inventor.fields.SoSFString;
import com.openinventor.inventor.fields.SoSFVec2f;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoBBox;
import com.openinventor.inventor.nodes.SoCallback;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoFont;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoLineSet;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoText2;
import com.openinventor.inventor.nodes.SoTextProperty;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.inventor.sensors.SoFieldSensor;

public class SliceScaleBar
extends SoAnnotation {
    public SoSFVec2f position = new SoSFVec2f((SoFieldContainer)this, "position", SoField.FieldTypes.EXPOSED_FIELD, new SbVec2f(0.0f, 0.0f));
    public SoSFString label = new SoSFString((SoFieldContainer)this, "label", SoField.FieldTypes.EXPOSED_FIELD, "");
    public SoSFFloat length = new SoSFFloat((SoFieldContainer)this, "length", SoField.FieldTypes.EXPOSED_FIELD, 1.0f);
    public SoSFInt32 numTickIntervals = new SoSFInt32((SoFieldContainer)this, "numTickIntervals", SoField.FieldTypes.EXPOSED_FIELD, 10);
    public SoSFNode trackedCamera = new SoSFNode((SoFieldContainer)this, "camera", SoField.FieldTypes.EXPOSED_FIELD, null);
    public SoSFEnum<Orientation> orientation = new SoSFEnum((SoFieldContainer)this, "orientation", SoField.FieldTypes.EXPOSED_FIELD, Orientation.class, (Enum)Orientation.HORIZONTAL);
    public SoSFEnum<Alignment> alignment = new SoSFEnum((SoFieldContainer)this, "alignment", SoField.FieldTypes.EXPOSED_FIELD, Alignment.class, (Enum)Alignment.CENTER);
    protected SoSeparator _lineSep;
    protected SoLineSet _axisLineSet;
    protected SoVertexProperty _vertProp;
    protected SoSeparator _textSep;
    protected SoTranslation _labelPos;
    protected SoFont _labelFont;
    protected SoText2 _labelText;
    protected boolean _cameraChanged = false;
    protected float _ndcLength = this.length.getValue();
    protected SbVec3f _p0;
    protected SbVec3f _p1;
    protected int _tickLenPix = 5;
    protected float _tickLenNdc;
    protected SbVec2f _pixelPerNdc;
    protected SbVec2i32 _winSizePix = new SbVec2i32(500, 500);
    protected SoFieldSensor _cameraFieldSensor;

    public SliceScaleBar() {
        this._pixelPerNdc = new SbVec2f(0.5f * (float)this._winSizePix.getX(), 0.5f * (float)this._winSizePix.getY());
        this._tickLenNdc = (float)this._tickLenPix / this._pixelPerNdc.getX();
        this.buildSceneGraph();
        this._cameraFieldSensor = new SoFieldSensor();
        this._cameraFieldSensor.setTask((Runnable)new FieldSensorCB(this._cameraFieldSensor));
        this._cameraFieldSensor.attach((SoField)this.trackedCamera);
    }

    protected void buildSceneGraph() {
        this.setName("SliceScaleBar");
        SoCallback soCallback = new SoCallback();
        soCallback.setCallback(new SoCallback.CB(){

            public void invoke(SoAction soAction) {
                if (soAction instanceof SoGLRenderAction || soAction instanceof SoGetBoundingBoxAction) {
                    SliceScaleBar.this.renderCB(soAction);
                }
            }
        });
        this.addChild((SoNode)soCallback);
        SoBBox soBBox = new SoBBox();
        soBBox.mode.setValue((Enum)SoBBox.Modes.NO_BOUNDING_BOX);
        this.addChild((SoNode)soBBox);
        SoLightModel soLightModel = new SoLightModel();
        soLightModel.model.setValue((Enum)SoLightModel.Models.BASE_COLOR);
        this.addChild((SoNode)soLightModel);
        SoPickStyle soPickStyle = new SoPickStyle();
        soPickStyle.style.setValue((Enum)SoPickStyle.Styles.UNPICKABLE);
        this.addChild((SoNode)soPickStyle);
        SoOrthographicCamera soOrthographicCamera = new SoOrthographicCamera();
        soOrthographicCamera.viewportMapping.setValue((Enum)SoCamera.ViewportMappings.LEAVE_ALONE);
        this.addChild((SoNode)soOrthographicCamera);
        this._lineSep = new SoSeparator();
        this.addChild((SoNode)this._lineSep);
        this._vertProp = new SoVertexProperty();
        this.computeEndPoints();
        this._vertProp.vertex.set1Value(0, this._p0);
        this._vertProp.vertex.set1Value(1, this._p1);
        this._axisLineSet = new SoLineSet();
        this._axisLineSet.vertexProperty.setValue((SoNode)this._vertProp);
        this._lineSep.addChild((SoNode)this._axisLineSet);
        this._textSep = new SoSeparator();
        this.addChild((SoNode)this._textSep);
        this._labelPos = new SoTranslation();
        this._textSep.addChild((SoNode)this._labelPos);
        this._labelFont = new SoFont();
        this._labelFont.size.setValue(15.0f);
        this._labelFont.name.setValue("Arial:Bold");
        this._labelFont.renderStyle.setValue((Enum)SoFont.RenderStyles.TEXTURE);
        this._textSep.addChild((SoNode)this._labelFont);
        SoTextProperty soTextProperty = new SoTextProperty();
        if (this.orientation.getValue() == Orientation.HORIZONTAL.getValue()) {
            soTextProperty.alignmentH.setValue((Enum)SoTextProperty.AlignmentHs.LEFT);
            soTextProperty.alignmentV.setValue((Enum)SoTextProperty.AlignmentVs.BASE);
        } else {
            soTextProperty.alignmentH.setValue((Enum)SoTextProperty.AlignmentHs.LEFT);
            soTextProperty.alignmentV.setValue((Enum)SoTextProperty.AlignmentVs.TOP);
        }
        this._textSep.addChild((SoNode)soTextProperty);
        this._labelText = new SoText2();
        this._labelText.justification.setValue((Enum)SoText2.Justifications.INHERITED);
        this._labelText.string.connectFrom((SoField)this.label);
        this._textSep.addChild((SoNode)this._labelText);
    }

    protected void computeEndPoints() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.orientation.getValue() == Orientation.HORIZONTAL.getValue()) {
            f3 = this._ndcLength;
            if (this.alignment.getValue() == Alignment.CENTER.getValue()) {
                f -= this._ndcLength / 2.0f;
            } else if (this.alignment.getValue() == Alignment.RIGHT.getValue()) {
                f -= this._ndcLength;
            }
        } else {
            f4 = this._ndcLength;
            if (this.alignment.getValue() == Alignment.CENTER.getValue()) {
                f2 -= this._ndcLength / 2.0f;
            } else if (this.alignment.getValue() == Alignment.TOP.getValue()) {
                f2 -= this._ndcLength;
            }
        }
        float f5 = this.position.getValue().getX();
        float f6 = this.position.getValue().getY();
        this._p0 = new SbVec3f(f5 += f, f6 += f2, 0.0f);
        this._p1 = new SbVec3f(f5 + f3, f6 + f4, 0.0f);
    }

    protected void renderCB(SoAction soAction) {
        boolean bl = false;
        SoState soState = soAction.getState();
        SbViewportRegion sbViewportRegion = SoViewportRegionElement.get((SoState)soState);
        SbViewVolume sbViewVolume = SoViewVolumeElement.get((SoState)soState);
        SbVec2i32 sbVec2i32 = sbViewportRegion.getViewportSizePixelsi32();
        if (sbVec2i32.getX() <= 0 || sbVec2i32.getY() <= 0) {
            return;
        }
        if (sbVec2i32.getX() != this._winSizePix.getX() || sbVec2i32.getY() != this._winSizePix.getY()) {
            bl = true;
            this._winSizePix = sbVec2i32;
            this._pixelPerNdc.setValue(0.5f * (float)this._winSizePix.getX(), 0.5f * (float)this._winSizePix.getY());
            int n = 1 - this.orientation.getValue();
            this._tickLenNdc = (float)this._tickLenPix / this._pixelPerNdc.getValueAt(n);
        }
        if (this._cameraChanged) {
            SbVec3f sbVec3f;
            SbVec3f sbVec3f2;
            this._cameraChanged = false;
            bl = true;
            SbVec3f sbVec3f3 = this._p1.minus(this._p0);
            sbVec3f3.divide(2.0f);
            SbVec3f sbVec3f4 = this._p0.plus(sbVec3f3);
            SbVec3f sbVec3f5 = sbViewVolume.projectFromScreen(sbVec3f4);
            SoCamera soCamera = (SoCamera)this.trackedCamera.getValue();
            float f = this.length.getValue();
            SbRotation sbRotation = soCamera.orientation.getValue();
            if (this.orientation.getValue() == Orientation.HORIZONTAL.getValue()) {
                sbVec3f2 = sbRotation.multVec(new SbVec3f(f / 2.0f, 0.0f, 0.0f));
                sbVec3f = sbRotation.multVec(new SbVec3f(-f / 2.0f, 0.0f, 0.0f));
            } else {
                sbVec3f2 = sbRotation.multVec(new SbVec3f(0.0f, f / 2.0f, 0.0f));
                sbVec3f = sbRotation.multVec(new SbVec3f(0.0f, -f / 2.0f, 0.0f));
            }
            SbVec3f sbVec3f6 = sbVec3f5.plus(sbVec3f);
            SbVec3f sbVec3f7 = sbVec3f5.plus(sbVec3f2);
            SbVec3f sbVec3f8 = sbViewVolume.projectToScreen(sbVec3f6);
            SbVec3f sbVec3f9 = sbViewVolume.projectToScreen(sbVec3f7);
            sbVec3f8.setX(2.0f * sbVec3f8.getX() - 1.0f);
            sbVec3f8.setY(2.0f * sbVec3f8.getY() - 1.0f);
            sbVec3f9.setX(2.0f * sbVec3f9.getX() - 1.0f);
            sbVec3f9.setY(2.0f * sbVec3f9.getY() - 1.0f);
            this._ndcLength = sbVec3f9.minus(sbVec3f8).length();
            this.computeEndPoints();
        }
        if (bl) {
            this.updateAxis();
        }
    }

    protected void resetLines() {
        this._axisLineSet.numVertices.deleteValues(0);
        this._vertProp.vertex.deleteValues(0);
    }

    protected void addLine(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        int n = this._vertProp.vertex.getNum();
        SbVec3f[] sbVec3fArray = new SbVec3f[]{sbVec3f, sbVec3f2};
        this._vertProp.vertex.setValues(n, sbVec3fArray);
        int n2 = this._axisLineSet.numVertices.getNum();
        int[] nArray = new int[]{2};
        this._axisLineSet.numVertices.setValues(n2, nArray);
    }

    protected void updateAxis() {
        SbVec3f sbVec3f;
        this._lineSep.enableNotify(false);
        this.resetLines();
        this.addLine(this._p0, this._p1);
        SbVec3f sbVec3f2 = new SbVec3f(0.0f, this._tickLenNdc, 0.0f);
        if (this.orientation.getValue() != Orientation.HORIZONTAL.getValue()) {
            sbVec3f2.setValue(this._tickLenNdc, 0.0f, 0.0f);
        }
        SbVec3f sbVec3f3 = this._p0.plus(sbVec3f2.times(1.25f));
        this.addLine(this._p0, sbVec3f3);
        sbVec3f3 = this._p1.plus(sbVec3f2.times(1.25f));
        this.addLine(this._p1, sbVec3f3);
        int n = this.numTickIntervals.getValue();
        if (n > 0) {
            float f = this._ndcLength / (float)n;
            SbVec3f sbVec3f4 = new SbVec3f(f, 0.0f, 0.0f);
            if (this.orientation.getValue() != Orientation.HORIZONTAL.getValue()) {
                sbVec3f4.setValue(0.0f, f, 0.0f);
            }
            for (int i = 1; i < n; ++i) {
                sbVec3f3 = this._p0.plus(sbVec3f4.times((float)i));
                SbVec3f sbVec3f5 = sbVec3f3.plus(sbVec3f2);
                this.addLine(sbVec3f3, sbVec3f5);
            }
        }
        this._lineSep.enableNotify(true);
        if (this.orientation.getValue() == Orientation.HORIZONTAL.getValue()) {
            sbVec3f = this._p1;
            sbVec3f.setX(sbVec3f.getX() + this._tickLenNdc);
        } else {
            float f = this._labelFont.size.getValue() / this._pixelPerNdc.getY();
            sbVec3f = this._p0;
            sbVec3f.setY(sbVec3f.getY() - (f + this._tickLenNdc));
        }
        this._textSep.enableNotify(false);
        this._labelPos.translation.setValue(sbVec3f);
        this._textSep.enableNotify(true);
    }

    private class FieldSensorCB
    implements Runnable {
        private SoFieldSensor _sensor;

        public FieldSensorCB(SoFieldSensor soFieldSensor) {
            this._sensor = soFieldSensor;
        }

        @Override
        public void run() {
            SoField soField = this._sensor.getAttachedField();
            if (soField == SliceScaleBar.this.trackedCamera) {
                SliceScaleBar.this._cameraChanged = true;
            }
        }
    }

    public static enum Alignment implements IntegerValuedEnum
    {
        LEFT(0),
        BOTTOM(0),
        CENTER(1),
        RIGHT(2),
        TOP(2);

        private final int _align;

        public int getValue() {
            return this._align;
        }

        private Alignment(int n2) {
            this._align = n2;
        }
    }

    public static enum Orientation implements IntegerValuedEnum
    {
        HORIZONTAL(0),
        VERTICAL(1);

        private final int _orient;

        private Orientation(int n2) {
            this._orient = n2;
        }

        public int getValue() {
            return this._orient;
        }
    }
}

