/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.swt.GLCanvas;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.devices.SoGLContext;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.sensors.SoSystemTimer;
import com.openinventor.inventor.viewercomponents.SoRawStereoParameters;
import com.openinventor.inventor.viewercomponents.SoRenderAreaCore;
import com.openinventor.inventor.viewercomponents.SoStereoParameters;
import com.openinventor.inventor.viewercomponents.swt.Timer;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas.OptionalStereoGLCapabilitiesChooser;
import org.eclipse.swt.widgets.Composite;

public class RenderArea
extends GLCanvas
implements GLEventListener {
    protected SoRenderAreaCore m_renderAreaCore = null;
    protected SoNode m_sceneGraph = null;

    public RenderArea(Composite composite, int n) {
        this(composite, n, null, (GLCapabilitiesChooser)new OptionalStereoGLCapabilitiesChooser());
    }

    public RenderArea(Composite composite, int n, GLCapabilities gLCapabilities) {
        this(composite, n, (GLCapabilitiesImmutable)gLCapabilities, (GLCapabilitiesChooser)new OptionalStereoGLCapabilitiesChooser());
    }

    private RenderArea(Composite composite, int n, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(composite, n, gLCapabilitiesImmutable, gLCapabilitiesChooser);
        SoDB.setSystemTimer((SoSystemTimer)new Timer());
        this.addGLEventListener(this);
    }

    public void activateStereo(boolean bl) {
        if (bl) {
            if (!this.isRawStereoAvailable()) {
                throw new UnsupportedOperationException("Stereo buffers are not enabled");
            }
            SoRawStereoParameters soRawStereoParameters = new SoRawStereoParameters();
            this.m_renderAreaCore.setStereoParameters((SoStereoParameters)soRawStereoParameters);
            this.m_renderAreaCore.activateStereo(true);
        } else {
            this.m_renderAreaCore.activateStereo(false);
        }
    }

    public boolean isRawStereoAvailable() {
        return this.getChosenGLCapabilities().getStereo();
    }

    public void setSceneGraph(SoNode soNode) {
        this.m_sceneGraph = soNode;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setSceneGraph(soNode);
        }
    }

    protected void render() {
        this.m_renderAreaCore.render();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        SoGLContext soGLContext = SoGLContext.getCurrent((boolean)true);
        this.m_renderAreaCore = new SoRenderAreaCore(soGLContext);
        this.m_renderAreaCore.setSceneGraph(this.m_sceneGraph);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.m_renderAreaCore.dispose();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.render();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.m_renderAreaCore.setSize(new SbVec2i32(n3, n4));
    }
}

