/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.swt.glcanvas.viewers;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas.RenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas.RenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.swt.tools.PreferencesDialog;
import com.openinventor.inventor.viewercomponents.swt.tools.SWTResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ViewerExaminer
extends Composite {
    private static Cursor seekCursor;
    private static Cursor viewingCursor;
    private static ToolItem seekItem;
    private RenderAreaExaminer m_renderArea;
    private SoSeparator m_sceneGraph;
    private SoGroup m_objectGroup;

    public ViewerExaminer(final Shell shell) {
        super((Composite)shell, 0);
        this.setLayout((Layout)new FillLayout(512));
        this.setLayoutData(new GridData(4, 4, true, true, 1, 2));
        seekCursor = new Cursor((Device)shell.getDisplay(), SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/CursorSeek.png").getImageData(), 16, 16);
        viewingCursor = new Cursor((Device)shell.getDisplay(), SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/CursorCurvedHand.png").getImageData(), 16, 16);
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setStereo(true);
        this.m_renderArea = new RenderAreaExaminer((Composite)this, 0, gLCapabilities);
        this.m_objectGroup = new SoGroup();
        this.m_sceneGraph = new SoSeparator();
        this.m_sceneGraph.addChild((SoNode)new SoGradientBackground());
        this.m_sceneGraph.addChild((SoNode)this.m_objectGroup);
        this.m_renderArea.setSceneGraph((SoNode)this.m_sceneGraph);
        this.addInteractionModeListener(new SceneExaminer.InteractionModeListener(){

            public void seekModeChanged(boolean bl) {
                seekItem.setSelection(bl);
                ViewerExaminer.this.updateUI(ViewerExaminer.this.getInteractionMode());
            }

            public void interactionModeChanged(SceneExaminer.InteractionMode interactionMode) {
                ViewerExaminer.this.updateUI(interactionMode);
            }
        });
        this.buildToolbar(shell);
        ToolBar toolBar = new ToolBar((Composite)shell, 0x820000);
        toolBar.setLayoutData((Object)new GridData(0x1000000, 1024, false, false, 1, 1));
        ToolItem toolItem = new ToolItem(toolBar, 0);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerExaminer.this.openPreferences(shell);
            }
        });
        toolItem.setToolTipText("Preferences...");
        toolItem.setImage(SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/preferences.png"));
        this.loadSceneGraph("$OIVJHOME/data/models/chair.iv");
        this.updateUI(this.getInteractionMode());
    }

    public void loadSceneGraph(String string) {
        SoInput soInput = new SoInput();
        if (!soInput.openFile(string)) {
            System.err.println("Cannot open file " + string);
            return;
        }
        SoSeparator soSeparator = SoDB.readAll((SoInput)soInput);
        if (soSeparator == null) {
            System.err.println("Problem reading file");
            return;
        }
        this.m_objectGroup.removeAllChildren();
        this.m_objectGroup.addChild((SoNode)soSeparator);
        this.viewAll();
        soInput.closeFile();
    }

    private void updateUI(SceneExaminer.InteractionMode interactionMode) {
        switch (interactionMode) {
            case NAVIGATION: {
                seekItem.setEnabled(true);
                if (seekItem.getSelection()) {
                    this.setCursor(seekCursor);
                    break;
                }
                this.setCursor(viewingCursor);
                break;
            }
            case SELECTION: {
                seekItem.setSelection(false);
                seekItem.setEnabled(false);
                this.setCursor(Display.getDefault().getSystemCursor(0));
                break;
            }
        }
    }

    private void buildToolbar(final Shell shell) {
        ToolBar toolBar = new ToolBar((Composite)shell, 0x820200);
        toolBar.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        ToolItem toolItem = new ToolItem(toolBar, 0);
        toolItem.setToolTipText("View All");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerExaminer.this.viewAll();
            }
        });
        toolItem.setImage(SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/ViewerViewAllTech.png"));
        ToolItem toolItem2 = new ToolItem(toolBar, 0);
        toolItem2.setToolTipText("YZ view");
        toolItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerExaminer.this.viewAxis(new SbVec3f(-1.0f, 0.0f, 0.0f), new SbVec3f(0.0f, 0.0f, 1.0f));
                ViewerExaminer.this.viewAll();
            }
        });
        toolItem2.setImage(SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/ViewerViewYZTech.png"));
        ToolItem toolItem3 = new ToolItem(toolBar, 0);
        toolItem3.setToolTipText("XZ view");
        toolItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerExaminer.this.viewAxis(new SbVec3f(0.0f, -1.0f, 0.0f), new SbVec3f(1.0f, 0.0f, 0.0f));
                ViewerExaminer.this.viewAll();
            }
        });
        toolItem3.setImage(SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/ViewerViewXZTech.png"));
        ToolItem toolItem4 = new ToolItem(toolBar, 0);
        toolItem4.setToolTipText("XY view");
        toolItem4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerExaminer.this.viewAxis(new SbVec3f(0.0f, 0.0f, -1.0f), new SbVec3f(0.0f, 1.0f, 0.0f));
                ViewerExaminer.this.viewAll();
            }
        });
        toolItem4.setImage(SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/ViewerViewXYTech.png"));
        ToolItem toolItem5 = new ToolItem(toolBar, 0);
        toolItem5.setImage(SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/ViewerHome.png"));
        toolItem5.setToolTipText("Restore Camera");
        toolItem5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerExaminer.this.restoreCamera();
            }
        });
        ToolItem toolItem6 = new ToolItem(toolBar, 0);
        toolItem6.setImage(SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/ViewerSetHome.png"));
        toolItem6.setToolTipText("Save Camera");
        toolItem6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerExaminer.this.saveCamera();
            }
        });
        ToolItem toolItem7 = new ToolItem(toolBar, 0);
        toolItem7.setImage(SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/ViewerOrtho.png"));
        toolItem7.setToolTipText("Switch to orthographic camera");
        toolItem7.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerExaminer.this.setCameraType(SceneInteractor.CameraMode.ORTHOGRAPHIC);
                PreferencesDialog.getInstance(shell).enableStereoPreferences(false);
            }
        });
        ToolItem toolItem8 = new ToolItem(toolBar, 0);
        toolItem8.setImage(SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/ViewerPerspective.png"));
        toolItem8.setToolTipText("Switch to perspective camera");
        toolItem8.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerExaminer.this.setCameraType(SceneInteractor.CameraMode.PERSPECTIVE);
                if (ViewerExaminer.this.isStereoSupported() && ViewerExaminer.this.isRawStereoAvailable()) {
                    PreferencesDialog.getInstance(shell).enableStereoPreferences(true);
                }
            }
        });
        seekItem = new ToolItem(toolBar, 32);
        seekItem.setImage(SWTResourceManager.getImage(ViewerExaminer.class, "/com/openinventor/inventor/viewercomponents/icons/ViewerSeek.png"));
        seekItem.setToolTipText("Seek");
        seekItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerExaminer.this.setSeekMode(seekItem.getSelection());
            }
        });
    }

    private void openPreferences(Shell shell) {
        PreferencesDialog preferencesDialog = PreferencesDialog.getInstance(shell);
        if (!this.isStereoSupported() || !this.isRawStereoAvailable()) {
            PreferencesDialog.getInstance(shell).enableStereoPreferences(false);
        } else if (preferencesDialog.getStereoListener() == null) {
            preferencesDialog.setStereoListener(new PreferencesDialog.StereoListener(){

                @Override
                public void offsetValueChanged(float f) {
                    ViewerExaminer.this.setStereoCameraOffset(f);
                }

                @Override
                public void balanceValueChanged(float f) {
                    ViewerExaminer.this.setStereoCameraBalance(f);
                }

                @Override
                public void activateRawStereo(boolean bl) {
                    ViewerExaminer.this.activateStereo(bl);
                }
            });
        }
        if (preferencesDialog.getGeneralPreferencesListener() == null) {
            preferencesDialog.setNavigationMode(this.getNavigationMode());
            preferencesDialog.setClippingPlanesAdjustMode(this.getClippingPlanesAdjustMode());
            preferencesDialog.setGeneralPreferencesListener(new PreferencesDialog.GeneralPreferencesListener(){

                @Override
                public void navigationModeChanged(SceneExaminer.NavigationMode navigationMode) {
                    ViewerExaminer.this.setNavigationMode(navigationMode);
                }

                @Override
                public void clippingModeChanged(RenderAreaInteractive.ClippingPlanesAdjustMode clippingPlanesAdjustMode) {
                    ViewerExaminer.this.setClippingPlanesAdjustMode(clippingPlanesAdjustMode);
                }
            });
        }
        preferencesDialog.open();
    }

    public void viewAll() {
        Point point = this.m_renderArea.getSize();
        this.m_renderArea.viewAll(new SbViewportRegion((short)point.x, (short)point.y));
    }

    public RenderAreaExaminer getRenderArea() {
        return this.m_renderArea;
    }

    public void saveCamera() {
        this.m_renderArea.saveCamera();
    }

    public void restoreCamera() {
        this.m_renderArea.restoreCamera();
    }

    public void setClippingPlanesAdjustMode(RenderAreaInteractive.ClippingPlanesAdjustMode clippingPlanesAdjustMode) {
        this.m_renderArea.setClippingPlanesAdjustMode(clippingPlanesAdjustMode);
    }

    public RenderAreaInteractive.ClippingPlanesAdjustMode getClippingPlanesAdjustMode() {
        return this.m_renderArea.getClippingPlanesAdjustMode();
    }

    public void setSeekMode(boolean bl) {
        this.m_renderArea.setSeekMode(bl);
    }

    public void setNavigationMode(SceneExaminer.NavigationMode navigationMode) {
        this.m_renderArea.setNavigationMode(navigationMode);
    }

    public SceneExaminer.NavigationMode getNavigationMode() {
        return this.m_renderArea.getNavigationMode();
    }

    public SceneExaminer.InteractionMode getInteractionMode() {
        return this.m_renderArea.getInteractionMode();
    }

    public void viewAxis(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        this.m_renderArea.viewAxis(sbVec3f, sbVec3f2);
    }

    public void addInteractionModeListener(SceneExaminer.InteractionModeListener interactionModeListener) {
        this.m_renderArea.addInteractionModeListener(interactionModeListener);
    }

    public void setCameraType(SceneInteractor.CameraMode cameraMode) {
        this.m_renderArea.setCameraType(cameraMode);
    }

    public boolean isRawStereoAvailable() {
        return this.m_renderArea.isRawStereoAvailable();
    }

    public boolean isStereoSupported() {
        return this.m_renderArea.isStereoSupported();
    }

    public void setCursor(Cursor cursor) {
        this.m_renderArea.setCursor(cursor);
    }

    public void activateStereo(boolean bl) {
        try {
            this.m_renderArea.activateStereo(bl);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            unsupportedOperationException.printStackTrace();
        }
    }

    public void setStereoCameraBalance(float f) {
        this.m_renderArea.setStereoCameraBalance(f);
    }

    public void setStereoCameraOffset(float f) {
        this.m_renderArea.setStereoCameraOffset(f);
    }
}

